package com.tydic.dyc.oc.model.sysdictionary.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.repository.UocSysDictionaryRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@Slf4j
public class IUocSysDictionaryModelImpl implements IUocSysDictionaryModel {

    @Autowired
    private UocSysDictionaryRepository uocSysDictionaryRepository;

    @Override
    public List<UocSysDictionaryDo> qryDicList(UocSysDictionaryQryBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSysDictionaryRepository.qryDicList(reqBO);
    }

    @Override
    public List<UocSysDictionaryDo> qryDicListByPCodes(List<String> pCodes) {
        return uocSysDictionaryRepository.qryDicListByPCodes(pCodes);
    }

    @Override
    public Map<String, Map<String, String>> getDictionaryMap(List<String> pCodes) {
        List<UocSysDictionaryDo> uocSysDictionaryDos = uocSysDictionaryRepository.qryDicListByPCodes(pCodes);
        Map<String, Map<String, String>> dicPCodeAndCodeMap = new HashMap<>();
        if (ObjectUtil.isNotEmpty(uocSysDictionaryDos)) {
            //根据pCode和code分组
            Map<String, List<UocSysDictionaryDo>> dicPCodeMap =
                    uocSysDictionaryDos.stream().collect(Collectors.groupingBy(UocSysDictionaryDo::getPCode));
            Iterator<String> iterator = dicPCodeMap.keySet().iterator();
            while (iterator.hasNext()) {
                String pCode = iterator.next();
                Map<String, String> dicCodeMap =
                        dicPCodeMap.get(pCode).stream().collect(Collectors.toMap(UocSysDictionaryDo::getCode, UocSysDictionaryDo::getDescrip, (k1, k2) -> k2));
                dicPCodeAndCodeMap.put(pCode, dicCodeMap);
            }
        }
        return dicPCodeAndCodeMap;
    }

    @Override
    public UocSysDictionaryDo getModelBy(UocSysDictionaryQryBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSysDictionaryRepository.getModelBy(reqBO);
    }

    @Override
    public UocSysDictionaryDo createDic(UocSysDictionaryDo uocSysDictionaryDo) {
        if (null == uocSysDictionaryDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        UocSysDictionaryQryBo qryBo = new UocSysDictionaryQryBo();
        qryBo.setPCode(uocSysDictionaryDo.getPCode());
        qryBo.setCode(uocSysDictionaryDo.getCode());
        UocSysDictionaryDo model =getModelBy(qryBo);
        if (null != model) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_DICTIONARY_CREATE_ERROR, "方法入参对象不能为空");
        }
        return uocSysDictionaryRepository.createDic(uocSysDictionaryDo);
    }

    @Override
    public UocSysDictionaryDo updateDic(UocSysDictionaryDo uocSysDictionaryDo) {
        if (null == uocSysDictionaryDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSysDictionaryRepository.updateDic(uocSysDictionaryDo);
    }

    @Override
    public UocSysDictionaryQryBo deleteDic(UocSysDictionaryQryBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSysDictionaryRepository.deleteDic(reqBO);
    }
}
