package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderUpdateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderUpdateRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：类名称:UocAfterOrderUpdateServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/11 15:04
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocAfterOrderUpdateServiceImpl implements UocAfterOrderUpdateService{
    @Autowired
    private IUocAfOrderModel afOrderModel;
    @Override
    public UocAfterOrderUpdateRspBo updateAfterOrder(UocAfterOrderUpdateReqBo reqBo) {
        validateArg(reqBo);
        UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
        uocAfOrderDo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderDo.setExtAfId(reqBo.getServiceId());
        afOrderModel.modifyAfOrderExtOrderId(uocAfOrderDo);
        return new UocAfterOrderUpdateRspBo();
    }

    private void validateArg(UocAfterOrderUpdateReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocAfterOrderCreateReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAfOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[售后单ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getServiceId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[外部售后单ID]不能为空");
        }
    }
}
