package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.config.UocInitConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocProcInsTerminateUpdateStateDomainBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocProcInsTerminateUpdateStateDomainServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocProcInsTerminateUpdateStateDomainServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocProcInsTerminateUpdateStateDomainServiceImpl
 * 说明:流程终止更新单据状态
 * 时间:2022-05-30 10:43:16
 * 作者:luoyou
 */
@Slf4j
@HTServiceImpl
public class UocProcInsTerminateUpdateStateDomainServiceImpl implements UocProcInsTerminateUpdateStateDomainService {

	@Autowired
	private IUocOrderModel iUocOrderModel;

	@Autowired
	private UocInitConfig uocInitConfig;

	@Autowired
	private IUocShipOrderModel iUocShipOrderModel;

	@Autowired
	private IUocSaleOrderModel iUocSaleOrderModel;

	@Autowired
	private IUocChngOrderModel iUocChngOrderModel;

	@Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

	private static final String LINE = "-";

	@Override
	public UocProcInsTerminateUpdateStateDomainServiceRspBo dealUpdateStateProcInsTerminate(UocProcInsTerminateUpdateStateDomainServiceReqBo reqBo) {
		val(reqBo);
		UocProcInsTerminateUpdateStateDomainServiceRspBo uocProcInsTerminateUpdateStateDomainServiceRspBo = UocRu.success(UocProcInsTerminateUpdateStateDomainServiceRspBo.class);
		List<UocOrderProcInst> uocOrderProcInstList = getUocOrderProcInsts(reqBo);
		if (!CollectionUtils.isEmpty(uocOrderProcInstList)) {
			List<UocOrderTaskInst> uocOrderTaskInsts = getUocOrderTaskInsts(reqBo, uocOrderProcInstList);
			if (!CollectionUtils.isEmpty(uocOrderTaskInsts)) {
				UocOrderTaskInst uocOrderTaskInst = uocOrderTaskInsts.get(0);
				log.info("流程完结uocOrderTaskInst：{}",uocOrderTaskInst.toString());
				String state = uocInitConfig.getStateByTachecode(uocOrderTaskInst.getProcState() + UocConstant.FINISH_OTHER_TAG.FINISH, uocOrderTaskInst.getObjType());
                log.info("流程完结state：{}",state);
				updateState(uocOrderTaskInst, state);
				putRspParam(reqBo, uocProcInsTerminateUpdateStateDomainServiceRspBo, uocOrderTaskInst);
			}
		}
		return uocProcInsTerminateUpdateStateDomainServiceRspBo;
	}

	private void putRspParam(UocProcInsTerminateUpdateStateDomainServiceReqBo reqBo, UocProcInsTerminateUpdateStateDomainServiceRspBo uocProcInsTerminateUpdateStateDomainServiceRspBo, UocOrderTaskInst uocOrderTaskInst) {
		UocProcInsTerminateUpdateStateDomainBo uocProcInsTerminateUpdateStateDomainBo = new UocProcInsTerminateUpdateStateDomainBo();
		uocProcInsTerminateUpdateStateDomainBo.setTaskId(uocOrderTaskInst.getTaskInstId());
		uocProcInsTerminateUpdateStateDomainBo.setBusiObjId(uocOrderTaskInst.getObjId());
		uocProcInsTerminateUpdateStateDomainBo.setBusiObjType(uocOrderTaskInst.getObjType());
		uocProcInsTerminateUpdateStateDomainServiceRspBo.getCompleteTaskInfos().add(uocProcInsTerminateUpdateStateDomainBo);
		uocProcInsTerminateUpdateStateDomainServiceRspBo.setOrderId(uocOrderTaskInst.getOrderId());
		reqBo.setOrderId(uocOrderTaskInst.getOrderId());
	}

	private List<UocOrderProcInst> getUocOrderProcInsts(UocProcInsTerminateUpdateStateDomainServiceReqBo reqBo) {
		UocOrderProcInstQryBo uocOrderProcInstQryBo = new UocOrderProcInstQryBo();
		uocOrderProcInstQryBo.setProcInstId(reqBo.getProcInstId());
		uocOrderProcInstQryBo.setOrderId(reqBo.getOrderId());
		uocOrderProcInstQryBo.setObjTypeNoInList(Collections.singletonList(UocDicConstant.OBJ_TYPE.APPROVE));
		return iUocOrderModel.qryOrderProcInstList(uocOrderProcInstQryBo);
	}

	private List<UocOrderTaskInst> getUocOrderTaskInsts(UocProcInsTerminateUpdateStateDomainServiceReqBo reqBo, List<UocOrderProcInst> uocOrderProcInstList) {
		UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
		uocOrderTaskInstQryBo.setProcInstId(reqBo.getProcInstId());
		uocOrderTaskInstQryBo.setOrderId(uocOrderProcInstList.get(0).getOrderId());
		List<Integer> finishTagList = new ArrayList<>();
		finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.FINISHED);//1
		finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);//2
		uocOrderTaskInstQryBo.setFinishTagList(finishTagList);
		uocOrderTaskInstQryBo.setOrderBy("finish_time desc");
		return iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
	}

	private void val(UocProcInsTerminateUpdateStateDomainServiceReqBo reqBo) {
		if (null == reqBo) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
		}
		if (StringUtils.isBlank(reqBo.getProcInstId())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参流程实例ID为空");
		}
	}

	private void updateState(UocOrderTaskInst uocOrderTaskInst, String state) {
		//环节，可能不变更状态，所以需要配置了状态才更新
		if (ObjectUtil.isNotEmpty(state)) {
			if (UocDicConstant.OBJ_TYPE.SHIP.equals(uocOrderTaskInst.getObjType())) {
				//更新销售单状态
				UocShipOrderDo updateShipDo = new UocShipOrderDo();
				updateShipDo.setOrderId(uocOrderTaskInst.getOrderId());
				updateShipDo.setShipOrderId(uocOrderTaskInst.getObjId());
				updateShipDo.setShipOrderState(state);
				updateShipDo.setUpdateTime(new Date());
				updateShipDo.setUpdateOperId(uocOrderTaskInst.getDealOperId());
				iUocShipOrderModel.updateShipStatusAndProCode(updateShipDo);
			}
			if (UocDicConstant.OBJ_TYPE.SALE.equals(uocOrderTaskInst.getObjType())) {
				//更新销售单状态和环节编码
				UocSaleOrderDo updateSaleDo = new UocSaleOrderDo();
				updateSaleDo.setUpdateOperId(uocOrderTaskInst.getDealOperId());
				updateSaleDo.setOrderId(uocOrderTaskInst.getOrderId());
				updateSaleDo.setSaleOrderId(uocOrderTaskInst.getObjId());
				updateSaleDo.setSaleOrderState(state);
				updateSaleDo.setUpdateTime(new Date());
				updateSaleDo.setUpdateOperName(uocOrderTaskInst.getDealOperName());
				iUocSaleOrderModel.updateSaleStatusAndProCode(updateSaleDo);
			}
			if (UocDicConstant.OBJ_TYPE.CHNG.equals(uocOrderTaskInst.getObjType())) {
				//更新销售单状态和环节编码
				UocChngOrderDo updateChngDo = new UocChngOrderDo();
				updateChngDo.setUpdateOperId(uocOrderTaskInst.getDealOperId());
				updateChngDo.setUpdateTime(new Date());
				updateChngDo.setUpdateOperName(uocOrderTaskInst.getDealOperName());
				updateChngDo.setOrderId(uocOrderTaskInst.getOrderId());
				updateChngDo.setChngOrderId(uocOrderTaskInst.getObjId());
				updateChngDo.setChngOrderState(state);
				iUocChngOrderModel.updateShipStatusAndProCode(updateChngDo);
			}
            if (UocDicConstant.OBJ_TYPE.ORDER.equals(uocOrderTaskInst.getObjType())) {
                //更新订单状态
                UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
                uocApprovalObjQryBo.setOrderId(uocOrderTaskInst.getOrderId());
                uocApprovalObjQryBo.setObjType(uocOrderTaskInst.getObjType());
                List<UocApprovalObj> approvalObjList = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
                if(ObjectUtil.isNotEmpty(approvalObjList)){
                    UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
                    uocOrderTaskInstQryBo.setOrderId(uocOrderTaskInst.getOrderId());
                    uocOrderTaskInstQryBo.setObjId(approvalObjList.get(0).getAuditOrderId());
                    uocOrderTaskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
                    uocOrderTaskInstQryBo.setOrderBy("create_time DESC");
                    List<UocOrderTaskInst> uocOrderTaskInstList = iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
                    if(Integer.valueOf(UocStateConstants.AUDIT_ORDER_STATUS.PASS).equals(uocOrderTaskInstList.get(0).getDealResult())){
                        //更新订单状态和环节编码
                        UocOrderDo uocOrderDo = new UocOrderDo();
                        uocOrderDo.setOrderId(uocOrderTaskInst.getOrderId());
                        uocOrderDo.setOrderState(state);
                        iUocOrderModel.updateOrderState(uocOrderDo);
    
                        //更新审批单状态 uoc_audit_order 为审批通过
                        UocAuditOrderDo updateDo = new UocAuditOrderDo();
                        updateDo.setOrderId(uocOrderTaskInst.getOrderId());
                        updateDo.setAuditOrderId(approvalObjList.get(0).getAuditOrderId());
                        log.info("审批通过状态更新 入参,{}", JSON.toJSONString(updateDo));
                        updateDo.setAuditOrderStatus(UocStateConstants.AUDIT_ORDER_STATUS.PASS);
                        iUocAuditOrderModel.updateApprove(updateDo);
                        
                    }else if(Integer.valueOf(UocStateConstants.AUDIT_ORDER_STATUS.REJECT).equals(uocOrderTaskInstList.get(0).getDealResult()) ){
                        UocOrderDo uocOrderDo = new UocOrderDo();
                        uocOrderDo.setOrderId(uocOrderTaskInst.getOrderId());
                        uocOrderDo.setOrderState(UocStateConstants.Order.ZD_SP_BHQX);
                        iUocOrderModel.updateOrderState(uocOrderDo);
    
                        //更新审批单状态 uoc_audit_order 为审批驳回
                        UocAuditOrderDo updateDo = new UocAuditOrderDo();
                        updateDo.setOrderId(uocOrderTaskInst.getOrderId());
                        updateDo.setAuditOrderId(approvalObjList.get(0).getAuditOrderId());
                        updateDo.setAuditOrderStatus(UocStateConstants.AUDIT_ORDER_STATUS.REJECT);
                        log.info("审批驳回状态更新 入参,{}", JSON.toJSONString(updateDo));
                        iUocAuditOrderModel.updateApprove(updateDo);
                    }
                }
            }
		}

	}
}
