package com.tydic.dyc.oc.service.shiporder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderMap;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDistSaleOrderRspBo;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderArrivaRegistReqBo;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderArrivaRegistRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocShipOrderArrivaRegistServiceImpl
 * 说明:发货单到货登记
 * 时间:2022/2/25 10:17
 * 作者:罗有
 */

@HTServiceImpl
public class UocShipOrderArrivaRegistServiceImpl implements UocShipOrderArrivaRegistService {

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Override
    public UocShipOrderArrivaRegistRspBo dealShipOrderArrivaRegist(UocShipOrderArrivaRegistReqBo reqBo) {
        //参数校验
        validateArg(reqBo);
        Date now = new Date();
        iUocShipOrderModel.modifyShipOrderMain(convertShipOrderDo(reqBo, now));
        dealMap(reqBo, now);

        // 5 提交任务
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(reqBo.getTaskId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        iUocCommonModel.dealTask(uocCommonDo);
        return UocRu.success(UocShipOrderArrivaRegistRspBo.class);
    }

    private UocShipOrderDo convertShipOrderDo(UocShipOrderArrivaRegistReqBo reqBo, Date now) {
        UocShipOrderDo uocShipOrderDo = UocRu.js(reqBo, UocShipOrderDo.class);
        uocShipOrderDo.setUpdateTime(now);
        uocShipOrderDo.setUpdateOperId(reqBo.getUserId().toString());
//        uocShipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_DQR);
        setAccessory(reqBo, now, uocShipOrderDo);
        return uocShipOrderDo;
    }

    /**
     * 组装附件参数
     */
    private void setAccessory(UocShipOrderArrivaRegistReqBo reqBo, Date now, UocShipOrderDo uocShipOrderDo) {
        if (!CollectionUtils.isEmpty(reqBo.getOrderAccessoryList())) {
            List<UocOrderAccessory> orderAccessoryBoList = new ArrayList<>();
            reqBo.getOrderAccessoryList().forEach(orderAccessoryAddBo -> {
                UocOrderAccessory uocOrderAccessory = UocRu.js(orderAccessoryAddBo, UocOrderAccessory.class);
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
                uocOrderAccessory.setCreateTime(now);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.ARRIVAL_REGIST);
                reqBo.getShipOrderIdList().forEach(shipOrderId -> {
                    uocOrderAccessory.setObjId(shipOrderId);
                    orderAccessoryBoList.add(uocOrderAccessory);
                });
            });
            uocShipOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
    }

    /**
     * 扩展属性处理
     */
    private void dealMap(UocShipOrderArrivaRegistReqBo reqBo, Date now) {
        if (!CollectionUtils.isEmpty(reqBo.getExtDeleteList())) {
            UocShipOrderDo delShipOrderDo = new UocShipOrderDo();
            List<UocShipOrderMap> extParallelBoList = new ArrayList<>();
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                UocShipOrderMap uocShipOrderMap = new UocShipOrderMap();
                uocShipOrderMap.setOrderId(reqBo.getOrderId());
//                uocShipOrderMap.setImplOrderId(reqBo.getImplOrderId());
                uocShipOrderMap.setSaleOrderId(reqBo.getSaleOrderId());
                uocShipOrderMap.setShipOrderId(uocBaseExtParallelDeleteBo.getObjId());
                uocShipOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                uocShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                uocShipOrderMap.setUpdateTime(now);
                extParallelBoList.add(uocShipOrderMap);
            });
            delShipOrderDo.setExtParallelBoList(extParallelBoList);
            iUocShipOrderModel.updateInvalid(delShipOrderDo);
        }
        if (!CollectionUtils.isEmpty(reqBo.getExtEditList())) {
            UocShipOrderDo add = new UocShipOrderDo();
            UocShipOrderDo modify = new UocShipOrderDo();
            List<UocShipOrderMap> addList = new ArrayList<>();
            List<UocShipOrderMap> modifyList = new ArrayList<>();
            reqBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                    UocShipOrderMap addShipOrderMap = new UocShipOrderMap();
                    addShipOrderMap.setShipOrderId(uocBaseExtParallelEditBo.getObjId());
                    addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                    addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    addShipOrderMap.setOrderId(reqBo.getOrderId());
//                    addShipOrderMap.setImplOrderId(reqBo.getImplOrderId());
                    addShipOrderMap.setSaleOrderId(reqBo.getSaleOrderId());
                    addShipOrderMap.setId(IdUtil.nextId());
                    addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                    addShipOrderMap.setCreateTime(now);
                    addList.add(addShipOrderMap);
                } else {
                    UocShipOrderMap updateShipOrderMap = new UocShipOrderMap();
                    updateShipOrderMap.setShipOrderId(uocBaseExtParallelEditBo.getObjId());
                    updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    updateShipOrderMap.setOrderId(reqBo.getOrderId());
                    updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                    updateShipOrderMap.setUpdateTime(now);
                    modifyList.add(updateShipOrderMap);
                }
            });
            if (!CollectionUtils.isEmpty(addList)) {
                add.setExtParallelBoList(addList);
                iUocShipOrderModel.addShipOrderMap(add);
            }
            if (!CollectionUtils.isEmpty(modifyList)) {
                modify.setExtParallelBoList(modifyList);
                iUocShipOrderModel.updateBatchValue(modify);
            }
        }
    }

    private void validateArg(UocShipOrderArrivaRegistReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
        if (CollectionUtils.isEmpty(reqBo.getShipOrderIdList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参发货单ID数组不能为空");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID为空");
        }
        if (!CollectionUtils.isEmpty(reqBo.getExtDeleteList())) {
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性对象ID不能为空");
                }
                if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性编码不能为空");
                }
            });
        }
        if (!CollectionUtils.isEmpty(reqBo.getExtEditList())) {
            reqBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型不能为空");
                }
                if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型仅支持新增和修改");
                }
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，对象ID不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，属性编码不能为空");
                    }
                }
                if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，对象ID不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性编码不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldValue())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性值不能为空");
                    }
                }
            });
        }
    }
}
