package com.tydic.dyc.oc.utils;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.*;

/**
 * 描述：ESB能力平台签名获取工具
 *
 * @author QIJIANFEI
 * @date 2017年8月17日 下午9:02:37
 * <p>
 **/
public class ESBSignUtil {

    /**
     * ESB发起机构AppSecret
     */
    private static final String KEY = "KEY";
    /**
     * ESB发起机构应用编码
     */
    private static final String APP_KEY = "APP_KEY";
    /**
     * 交易流水号 (一次调用的唯一流水号，20位定长 生成规则：中心代码（2位）+时间戳（14）+随机码（4位） )
     */
    private static final String SERIALNUMBER = "SERIALNUMBER";
    /**
     * 时间戳(格式为yyyy-MM-dd HH:mm:ss)
     */
    private static final String TIMESTAMP = "TIMESTAMP";
    /**
     * TOKEN
     */
    private static final String TOKEN = "TOKEN";

    /**
     * <br>
     * 适用场景: 获取ESB的Token<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年8月17日 下午8:58:47
     */
    public static String getESBToken(String characterEncoding, String key, String appkey, String serialnumber, String timesTamp) {
        SortedMap<Object, Object> parameters = new TreeMap<>();

        parameters.put(KEY, key);
        parameters.put(APP_KEY, appkey);
        parameters.put(SERIALNUMBER, serialnumber);
        parameters.put(TIMESTAMP, timesTamp);

        return createToken(characterEncoding, parameters);
    }

    /**
     * <br>
     * 适用场景:token签名 <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param characterEncoding
     * @param parameters
     * @return
     * @throws NoSuchAlgorithmException
     * @throws UnsupportedEncodingException
     * @autho QIJIANFEI
     * @time 2017年8月17日 下午9:03:16
     */
    private static String createToken(String characterEncoding, SortedMap<Object, Object> parameters) {
        StringBuffer sb = new StringBuffer();
        Set es = parameters.entrySet();
        Iterator it = es.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry) it.next();
            String k = (String) entry.getKey();
            Object v = entry.getValue();
            if (v instanceof String[]) {
                v = ((String[]) v)[0];
            }
            if (null != v && !"".equals(v) && !TOKEN.equals(k) && !KEY.equals(k)) {
                sb.append(k).append(v);
            }
        }
        sb.append(parameters.get(KEY));

        return getMD5Encode(characterEncoding, sb.toString());
    }

    /**
     * md5 base64加密
     *
     * @param characterEncoding 编码类型（如UTF-8）
     * @param md5Code           需要md5加密的字符串
     * @return String
     */
    private static String getMD5Encode(String characterEncoding, String md5Code) {
        return MD5Util.MD5Encode(md5Code, characterEncoding);
    }

//    public static void main(String[] args) {
//        String characterEncoding = "UTF-8";
//        String key = "efuxyS3jRnmxrFUO8MNuoiHdbErqdWV4";
//        String appid = "gd";
//        String transId = "20170817101001522685751";
//        String timesTamp = "20170817101001522";
//        System.out.println(getESBToken(characterEncoding, key, appid, transId, timesTamp));
//    }

}
