/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.ListUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.UocShouldPayCreateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCreateBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCreateReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCreateRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="3.0.0", serviceGroup="OC_GROUP_DEV", serviceInterface=UocShouldPayCreateService.class)
public class UocShouldPayCreateServiceImpl
implements UocShouldPayCreateService {
    private static final Logger log = LoggerFactory.getLogger(UocShouldPayCreateServiceImpl.class);
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private UocEsSyncManager uocEsSyncManager;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    public static final List<String> pCodeList = ListUtil.list((boolean)false);

    private static void initialize() {
        pCodeList.add("SHOULD_PAY_TYPE");
    }

    public UocShouldPayCreateRspBO create(UocShouldPayCreateReqBO reqBO) {
        UocOrderShouldPay uocOrderShouldPay;
        if (reqBO == null || CollectionUtils.isEmpty((Collection)reqBO.getUocShouldPayCreateBoList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        for (UocShouldPayCreateBo item : reqBO.getUocShouldPayCreateBoList()) {
            uocOrderShouldPay = UocRu.js(item, UocOrderShouldPay.class);
            uocOrderShouldPay.setShouldPayId(IdUtil.nextId());
            uocOrderShouldPay.setCreateTime(new Date());
            uocOrderShouldPay.setIsPayCompleted(UocDicConstant.SHOULD_PAY_ORDER_PAY_STATE.NOT_PAY_COMPLETED);
            this.iUocPayOrderModel.createShouldPayOrder(uocOrderShouldPay);
        }
        for (UocShouldPayCreateBo item : reqBO.getUocShouldPayCreateBoList()) {
            if (!UocDicConstant.OBJ_TYPE.SALE.equals(reqBO.getObjectType())) continue;
            uocOrderShouldPay = new UocOrderShouldPay();
            uocOrderShouldPay.setOrderId(item.getOrderId());
            uocOrderShouldPay.setObjectId(item.getObjectId());
            uocOrderShouldPay.setObjectType(UocDicConstant.OBJ_TYPE.SALE);
            uocOrderShouldPay.setIsPayCompleted(UocDicConstant.SHOULD_PAY_ORDER_PAY_STATE.NOT_PAY_COMPLETED);
            log.info("\u67e5\u8be2\u672a\u652f\u4ed8\u72b6\u6001\u7684\u5e94\u4ed8\u5355\u5165\u53c2\u4e3a:{}", (Object)JSONObject.toJSONString((Object)uocOrderShouldPay));
            List<UocOrderShouldPay> listOrderShouldPay = this.iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
            log.info("\u67e5\u8be2\u672a\u652f\u4ed8\u72b6\u6001\u7684\u5e94\u4ed8\u5355\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSONObject.toJSONString(listOrderShouldPay));
            if (CollectionUtils.isEmpty(listOrderShouldPay)) continue;
            JSONArray jsonArray = new JSONArray();
            for (UocOrderShouldPay shouldPayItem : listOrderShouldPay) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("fscShouldPayId", (Object)shouldPayItem.getFscShouldPayId());
                jsonObject.put("shouldPayAmount", (Object)shouldPayItem.getShouldPayAmount());
                jsonObject.put("paidAmount", (Object)shouldPayItem.getPaidAmount());
                jsonObject.put("shouldPayType", (Object)shouldPayItem.getShouldPayType());
                jsonObject.put("payerId", (Object)shouldPayItem.getPayerId());
                jsonObject.put("payeeId", (Object)shouldPayItem.getPayeeId());
                if (null != shouldPayItem.getShouldPayType()) {
                    jsonObject.put("shouldPayTypeStr", (Object)dictionaryMap.get("SHOULD_PAY_TYPE").get(String.valueOf(shouldPayItem.getShouldPayType())));
                }
                jsonArray.add((Object)jsonObject);
            }
            log.info("\u540c\u6b65\u7684jsonArray\u4e3a\uff1a{}", (Object)jsonArray);
            this.syncEs(item.getObjectId(), jsonArray);
        }
        return UocRu.success(UocShouldPayCreateRspBO.class);
    }

    private void syncEs(Long objId, JSONArray jsonArray) {
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        uocEsSyncManagerSaveDataReqBo.setObjId(objId);
        uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("orderShouldPayList", (Object)jsonArray);
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        log.info("\u5e94\u4ed8\u5355\u751f\u6210uocEsSyncManagerSaveDataReqBo\u4e3a{}", (Object)JSONObject.toJSONString((Object)uocEsSyncManagerSaveDataReqBo));
        this.uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }

    static {
        UocShouldPayCreateServiceImpl.initialize();
    }
}

