/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.UocDistSaleOrderService;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDistSaleOrderReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDistSaleOrderRspBo;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="3.0.0", serviceGroup="OC_GROUP_DEV", serviceInterface=UocDistSaleOrderService.class)
public class UocDistSaleOrderServiceImpl
implements UocDistSaleOrderService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    public UocDistSaleOrderRspBo distSaleOrder(UocDistSaleOrderReqBo reqBo) {
        UocDistSaleOrderRspBo rspBo = new UocDistSaleOrderRspBo();
        this.verifyParam(reqBo);
        this.updateSaleOrderInfo(reqBo);
        this.submitOrderTask(reqBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void submitOrderTask(UocDistSaleOrderReqBo reqBo) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskList = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        task.setTaskId(reqBo.getTaskId());
        taskList.add(task);
        uocCommonDo.setCompleteTaskInfos(taskList);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }

    private void updateSaleOrderInfo(UocDistSaleOrderReqBo reqBo) {
        UocSaleOrderDo updateUocSaleOrder = new UocSaleOrderDo();
        BeanUtils.copyProperties((Object)reqBo, (Object)updateUocSaleOrder);
        updateUocSaleOrder.setUpdateTime(new Date());
        updateUocSaleOrder.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        updateUocSaleOrder.setUpdateOperName(reqBo.getName());
        this.iUocSaleOrderModel.modifySaleOrderMain(updateUocSaleOrder);
    }

    private void verifyParam(UocDistSaleOrderReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("100001", "\u5f53\u524d\u767b\u5f55\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getName())) {
            throw new BaseBusinessException("100001", "\u5f53\u524d\u767b\u5f55\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getProDeliveryId())) {
            throw new BaseBusinessException("100001", "\u534f\u8bae\u7ecf\u529e\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getProDeliveryName())) {
            throw new BaseBusinessException("100001", "\u534f\u8bae\u7ecf\u529e\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getTaskId())) {
            throw new BaseBusinessException("100001", "\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

