package com.tydic.dyc.oc.service.cmporder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigItemDo;
import com.tydic.dyc.oc.service.cmporder.bo.UocMustCompareOrderConfigUpdateServiceReqBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocMustCompareOrderConfigUpdateServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:UocMustCompareOrderConfigUpdateServiceImpl
 * 说明:订单商品是否必须比选更新服务
 * 时间:2023/1/4 11:00
 * 作者:田桂银
 */
@HTServiceImpl
public class UocMustCompareOrderConfigUpdateServiceImpl implements UocMustCompareOrderConfigUpdateService {

    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Override
    public UocMustCompareOrderConfigUpdateServiceRspBo updateConfig(UocMustCompareOrderConfigUpdateServiceReqBo reqBo) {
        validateArg(reqBo);
        UocMustCompareOrderConfigUpdateServiceRspBo rspBo = UocRu.success(UocMustCompareOrderConfigUpdateServiceRspBo.class);
        UocCfcParamConfigItemDo updateDo = new UocCfcParamConfigItemDo();
        updateDo.setItemId(reqBo.getItemId());
        updateDo.setItemValue(reqBo.getItemValue());
        updateDo.setCreateId(reqBo.getUserIdIn());
        updateDo.setCreateName(reqBo.getCustNameIn());
        iUocCommonModel.updateCfcItemValue(updateDo);
        return rspBo;
    }

    private void validateArg(UocMustCompareOrderConfigUpdateServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getItemId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[itemId]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getItemValue())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[itemValue]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUserIdIn())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[userIdIn]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getCustNameIn())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[custNameIn]不能为空");
        }
    }
}


