package com.tydic.dyc.oc.service.domainservice;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetCheckVoterOrdersReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetCheckVoterOrdersRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderBO;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderBo;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderItemBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@HTServiceImpl
public class UocGetCheckVoterOrdersServiceImpl implements UocGetCheckVoterOrdersService{
    
    @Autowired
    private IUocShipOrderModel uocShipOrderModel;
    
    @Autowired
    private IUocSaleOrderModel uocSaleOrderModel;
    
    
    @Override
    public UocGetCheckVoterOrdersRspBO getCheckShipOrders(UocGetCheckVoterOrdersReqBO reqBO) {
        UocGetCheckVoterOrdersRspBO rspBO = UocRu.success(UocGetCheckVoterOrdersRspBO.class);
    
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setSupNo(reqBO.getSupId());
        uocShipOrderDo.setArriveTimeStart(DateUtils.strToDate(reqBO.getArriveTimeStart(),"yyyy-MM-dd HH:mm:ss"));
        uocShipOrderDo.setArriveTimeEnd(DateUtils.strToDate(reqBO.getArriveTimeEnd(),"yyyy-MM-dd HH:mm:ss"));
    
        List<UocShipOrderDo> uocShipOrderDos = new ArrayList<>();
        if(reqBO.getCheckType() == 2){
            uocShipOrderDos  = uocShipOrderModel.getCheckVoterOrders(uocShipOrderDo);
        }else if(reqBO.getCheckType() == 3){
            uocShipOrderDos  = uocShipOrderModel.getCheckRefuseOrders(uocShipOrderDo);
        }
        List<UocShipOrderBo> uocShipOrderBos = UocRu.jsl(uocShipOrderDos, UocShipOrderBo.class);
    
        Map<Long,List<UocShipOrderItemBo>> shipItemMap = uocShipOrderBos.stream().collect(Collectors.toMap(UocShipOrderBo::getShipOrderId,UocShipOrderBo::getShipOrderItemBoList));
        
        shipItemMap.forEach((k,v)->{
            for(UocShipOrderItemBo shipOrderItem: v){
                UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
                uocSaleOrderItemQryBo.setSaleOrderItemId(shipOrderItem.getSaleOrderItemId());
                List<UocSaleOrderItem> saleOrderItems = uocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                shipOrderItem.setArrivePrice(shipOrderItem.getArriveCount().multiply(saleOrderItems.get(0).getSalePrice()));
                shipOrderItem.setRejectPrice(shipOrderItem.getRefuseCount().multiply(saleOrderItems.get(0).getSalePrice()));
            }
        });
        
        for(UocShipOrderBo uocShipOrderBo: uocShipOrderBos){
            BigDecimal arrivePrice = new BigDecimal("0");
            BigDecimal rejectPrice = new BigDecimal("0");
            for (UocShipOrderItemBo uocShipOrderItemBo: uocShipOrderBo.getShipOrderItemBoList()){
                arrivePrice = arrivePrice.add(uocShipOrderItemBo.getArrivePrice());
                rejectPrice = rejectPrice.add(uocShipOrderItemBo.getRejectPrice());
            }
            uocShipOrderBo.setArrivePrice(arrivePrice);
            uocShipOrderBo.setRejectPrice(rejectPrice);
        }
        rspBO.setUocShipOrderBos(uocShipOrderBos);
        return rspBO;
    }
}
