/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.config.mq;

import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.tydic.dyc.oc.config.mq.consumer.UocSaleOrderSyncConsumer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class UocSaleOrderSyncMqConfig {
    @Value(value="${data.sync.event.pid:EVENT_PID}")
    private String orderCreatePid;
    @Value(value="${data.sync.event.topic:EVENT_TOPIC_LOCAL}")
    private String orderCreateTopic;
    @Value(value="${data.sync.event.tag:UOC}")
    private String orderCreateTag;

    @Bean(value={"uocSaleOrderSyncConsumer"})
    public UocSaleOrderSyncConsumer uocCreateOrderConsumer() {
        UocSaleOrderSyncConsumer uocCreateOrderConsumer = new UocSaleOrderSyncConsumer();
        uocCreateOrderConsumer.setId(this.orderCreatePid);
        uocCreateOrderConsumer.setSubject(this.orderCreateTopic);
        String[] tags = new String[]{this.orderCreateTag};
        uocCreateOrderConsumer.setTags(tags);
        return uocCreateOrderConsumer;
    }

    @Bean(value={"uocSaleOrderSyncProvider"}, initMethod="startup", destroyMethod="shutdown")
    public ProxyProducerFactoryBean uocSaleOrderSyncProxyProducerFactoryBean() {
        DefaultProxyMessageConfig defaultProxyMessageConfig = new DefaultProxyMessageConfig();
        defaultProxyMessageConfig.setId(this.orderCreatePid);
        ProxyProducerFactoryBean proxyProducerFactoryBean = new ProxyProducerFactoryBean();
        proxyProducerFactoryBean.setMessageConfig((ProxyMessageConfig)defaultProxyMessageConfig);
        return proxyProducerFactoryBean;
    }
}

