package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderStateServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderStateServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 描述: 〈领域服务-销售单状态更新 实现〉
 * @author : yuhao
 * @date : 2022/7/20 13:27
 */
@HTServiceImpl
public class UocUpdateSaleOrderStateServiceImpl implements UocUpdateSaleOrderStateService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocUpdateSaleOrderStateServiceRspBo updateSaleOrderState(UocUpdateSaleOrderStateServiceReqBo reqBo) {
        validateArg(reqBo);
        UocUpdateSaleOrderStateServiceRspBo rspBo = UocRu.success(UocUpdateSaleOrderStateServiceRspBo.class);
        //修改状态
        UocSaleOrderDo updateSaleOrderStateDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        updateSaleOrderStateDo.setUpdateOperId(reqBo.getUserId().toString());
        //更新销售单状态
        iUocSaleOrderModel.updateSaleStatusAndProCode(updateSaleOrderStateDo);
        return rspBo;
    }

    private void validateArg(UocUpdateSaleOrderStateServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocUpdateSaleOrderStateServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUserId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【用户id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【订单id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【销售单id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderState())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【订单状态】不能为空");
        }
    }
}


