/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.common;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.sub.UocConfSupplierDO;
import com.tydic.dyc.oc.service.common.UocQrySupplierQuotaConfigService;
import com.tydic.dyc.oc.service.common.bo.UocQrySupplierQuotaConfigReqBo;
import com.tydic.dyc.oc.service.common.bo.UocQrySupplierQuotaConfigReqSkuBo;
import com.tydic.dyc.oc.service.common.bo.UocQrySupplierQuotaConfigRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.common.UocQrySupplierQuotaConfigService"})
public class UocQrySupplierQuotaConfigServiceImpl
implements UocQrySupplierQuotaConfigService {
    @Autowired
    private IUocCommonModel uocCommonModel;

    @PostMapping(value={"checkSupQuotaLimit"})
    public UocQrySupplierQuotaConfigRspBo checkSupQuotaLimit(@RequestBody UocQrySupplierQuotaConfigReqBo reqBo) {
        this.validateArgs(reqBo);
        Set supplierSet = reqBo.getItemList().stream().map(UocQrySupplierQuotaConfigReqSkuBo::getGoodsSupplierId).collect(Collectors.toSet());
        UocConfSupplierDO uocConfSupplierDO = new UocConfSupplierDO();
        uocConfSupplierDO.setSupplierNos(new ArrayList<String>(supplierSet));
        uocConfSupplierDO.setLimitStatus(0);
        List<UocConfSupplierDO> uocConfSupplierDoS = this.uocCommonModel.qryConfSupplierList(uocConfSupplierDO);
        Map supConfigMap = uocConfSupplierDoS.stream().collect(Collectors.toMap(UocConfSupplierDO::getSupNo, Function.identity()));
        Map<String, List<UocQrySupplierQuotaConfigReqSkuBo>> supMap = reqBo.getItemList().stream().collect(Collectors.groupingBy(UocQrySupplierQuotaConfigReqSkuBo::getGoodsSupplierId));
        for (Map.Entry<String, List<UocQrySupplierQuotaConfigReqSkuBo>> tMap : supMap.entrySet()) {
            String key = tMap.getKey();
            List<UocQrySupplierQuotaConfigReqSkuBo> value = tMap.getValue();
            UocConfSupplierDO confSupplierDO = (UocConfSupplierDO)supConfigMap.get(key);
            if (confSupplierDO == null) {
                uocConfSupplierDO.setSupNo("0");
                uocConfSupplierDO.setSupplierNos(null);
                uocConfSupplierDO.setBusinessTypeCode(Integer.toString(value.get(0).getBusinessTypeCode()));
                uocConfSupplierDoS = this.uocCommonModel.qryConfSupplierList(uocConfSupplierDO);
                if (CollectionUtils.isEmpty(uocConfSupplierDoS)) continue;
                confSupplierDO = uocConfSupplierDoS.get(0);
            }
            BigDecimal totalPrice = new BigDecimal(0);
            for (UocQrySupplierQuotaConfigReqSkuBo skuBo : value) {
                if (confSupplierDO.getOrderLimit() == null) continue;
                totalPrice = skuBo.getPurchaseCount().multiply(skuBo.getSkuSalePrice()).add(totalPrice);
            }
            if (!StringUtils.isNotBlank((CharSequence)confSupplierDO.getOrderLimit()) || new BigDecimal(confSupplierDO.getOrderLimit()).divide(new BigDecimal(10000), 3, 4).subtract(totalPrice).compareTo(BigDecimal.ZERO) <= 0) continue;
            return UocRu.failed("8888", confSupplierDO.getSupName() + "\u4e0b\u7684\u8ba2\u5355\u4e0d\u6ee1\u8db3[" + new BigDecimal(confSupplierDO.getOrderLimit()).divide(new BigDecimal(10000), 3, 4).toString() + "]\u5143\uff0c\u4e0d\u5141\u8bb8\u4e0b\u5355\u3002", UocQrySupplierQuotaConfigRspBo.class);
        }
        return UocRu.success(UocQrySupplierQuotaConfigRspBo.class);
    }

    private void validateArgs(UocQrySupplierQuotaConfigReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List itemList = reqBo.getItemList();
        if (ObjectUtil.isEmpty((Object)itemList)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5c5e\u6027itemList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocQrySupplierQuotaConfigReqSkuBo tBo : itemList) {
            if (ObjectUtil.isEmpty((Object)tBo)) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tBo.getGoodsSupplierId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[goodsSupplierId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tBo.getPurchaseCount())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[purchaseCount]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tBo.getSkuId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)tBo.getSkuSalePrice())) continue;
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[skuSalePrice]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

