/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfTabOrdStateQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfTabOrdState;
import com.tydic.dyc.oc.service.domainservice.UocQryTableConfiguredStateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryTableConfiguredStateServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryTableConfiguredStateServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocTableStateBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocQryTableConfiguredStateService"})
public class UocQryTableConfiguredStateServiceImpl
implements UocQryTableConfiguredStateService {
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"queryTableConfigState"})
    public UocQryTableConfiguredStateServiceRspBo queryTableConfigState(@RequestBody UocQryTableConfiguredStateServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UocQryTableConfiguredStateServiceRspBo rspBo = UocRu.success(UocQryTableConfiguredStateServiceRspBo.class);
        List<Object> tabStateList = new ArrayList();
        UocConfTabOrdStateQryBo uocConfTabOrdStateQryBo = UocRu.js(reqBo, UocConfTabOrdStateQryBo.class);
        uocConfTabOrdStateQryBo.setOrderBy("sort");
        List<UocConfTabOrdState> uocConfTabOrdStates = this.iUocOrderModel.qryConfTabOrdStateList(uocConfTabOrdStateQryBo);
        if (ObjectUtil.isNotEmpty(uocConfTabOrdStates)) {
            HashMap tabStateMap = new HashMap();
            HashMap tabSubStateMap = new HashMap();
            HashMap tabStatusMap = new HashMap();
            HashMap tabDoneTacheCodeMap = new HashMap();
            HashMap orderSourceMap = new HashMap();
            uocConfTabOrdStates.forEach(each -> {
                if (ObjectUtil.isNotEmpty((Object)each.getOrderStatusCode())) {
                    tabStateMap.put(each.getTabId(), Arrays.asList(StringUtils.split((String)each.getOrderStatusCode(), (String)",")));
                }
                if (ObjectUtil.isNotEmpty((Object)each.getSubOrderStatusCode())) {
                    tabSubStateMap.put(each.getTabId(), Arrays.asList(StringUtils.split((String)each.getSubOrderStatusCode(), (String)",")));
                }
                if (ObjectUtil.isNotEmpty((Object)each.getOrderStatus())) {
                    tabStatusMap.put(each.getTabId(), Arrays.asList(StringUtils.split((String)each.getOrderStatus(), (String)",")));
                }
                if (ObjectUtil.isNotEmpty((Object)each.getDoneTacheCode())) {
                    tabDoneTacheCodeMap.put(each.getTabId(), Arrays.asList(StringUtils.split((String)each.getDoneTacheCode(), (String)",")));
                }
                if (ObjectUtil.isNotEmpty((Object)each.getOrderSource())) {
                    orderSourceMap.put(each.getTabId(), Arrays.asList(StringUtils.split((String)each.getOrderSource(), (String)",")));
                }
            });
            tabStateList = UocRu.jsl(uocConfTabOrdStates, UocTableStateBo.class);
            for (UocTableStateBo uocTableStateBo : tabStateList) {
                if (ObjectUtil.isNotEmpty(tabStateMap) && tabStateMap.containsKey(uocTableStateBo.getTabId())) {
                    uocTableStateBo.setTabStateList((List)tabStateMap.get(uocTableStateBo.getTabId()));
                }
                if (ObjectUtil.isNotEmpty(tabSubStateMap) && tabSubStateMap.containsKey(uocTableStateBo.getTabId())) {
                    uocTableStateBo.setTabSubStateList((List)tabSubStateMap.get(uocTableStateBo.getTabId()));
                }
                if (ObjectUtil.isNotEmpty(tabStatusMap) && tabStatusMap.containsKey(uocTableStateBo.getTabId())) {
                    uocTableStateBo.setTabStatusList((List)tabStatusMap.get(uocTableStateBo.getTabId()));
                }
                if (ObjectUtil.isNotEmpty(tabDoneTacheCodeMap) && tabDoneTacheCodeMap.containsKey(uocTableStateBo.getTabId())) {
                    uocTableStateBo.setDoneTacheCodeList((List)tabDoneTacheCodeMap.get(uocTableStateBo.getTabId()));
                }
                if (!ObjectUtil.isNotEmpty(orderSourceMap) || !orderSourceMap.containsKey(uocTableStateBo.getTabId())) continue;
                uocTableStateBo.setOrderSourceList((List)orderSourceMap.get(uocTableStateBo.getTabId()));
            }
        }
        rspBo.setTableStateBoList(tabStateList);
        return rspBo;
    }

    private void validateArg(UocQryTableConfiguredStateServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocQryTableConfiguredStateServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getTabIdList()) && ObjectUtil.isEmpty((Object)reqBo.getMenuCode())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9875\u7b7eIdList]\u548c[menuCode]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }

    private void update(List<UocTableStateBo> tabStateList) {
        tabStateList.forEach(uocTableStateBo -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("saleOrderStates", uocTableStateBo.getTabStatusList() == null ? new ArrayList() : uocTableStateBo.getTabStatusList());
            jsonObject.put("tacheCodes", uocTableStateBo.getTabStateList() == null ? new ArrayList() : uocTableStateBo.getTabStateList());
            jsonObject.put("doneTaskTacheCodeList", uocTableStateBo.getDoneTacheCodeList() == null ? new ArrayList() : uocTableStateBo.getDoneTacheCodeList());
            jsonObject.put("shipOrderTacheCodes", uocTableStateBo.getTabSubStateList() == null ? new ArrayList() : uocTableStateBo.getTabSubStateList());
            jsonObject.put("orderSourceList", uocTableStateBo.getOrderSourceList() == null ? new ArrayList() : uocTableStateBo.getOrderSourceList());
            UocConfTabOrdState uocConfTabOrdState = new UocConfTabOrdState();
            uocConfTabOrdState.setId(uocTableStateBo.getId());
            uocConfTabOrdState.setParamJson(jsonObject.toJSONString());
            this.iUocOrderModel.modifyTabConf(uocConfTabOrdState);
        });
    }
}

