/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.config.mq.consumer;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.datasync.event.bo.ChannelEvent;
import com.tydic.dyc.base.events.Event;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.EventConsumerManger;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.constants.UocConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class UocSaleOrderSyncConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(UocSaleOrderSyncConsumer.class);
    private Logger logger = LoggerFactory.getLogger(UocSaleOrderSyncConsumer.class);
    @Autowired
    private UocEsSyncManager SyncManager;
    @Autowired
    private EventConsumerManger eventConsumerManger;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        ChannelEvent eventList;
        List events;
        String content = proxyMessage.getContent();
        log.info("es\u6d88\u8d39\u8005\u6536\u5230\uff0c\u6570\u636e\u5185\u5bb9\u5982\u4e0b:{}", (Object)JSON.toJSONString((Object)content));
        if (ObjectUtil.isNotEmpty((Object)content) && ObjectUtil.isNotEmpty((Object)(events = (eventList = (ChannelEvent)JSON.parseObject((String)content, ChannelEvent.class)).getTraceEventList()))) {
            for (Event event : events) {
                EventConsumer eventConsumer;
                String eventCode = event.getCode();
                Map paramMap = event.getParamMap();
                try {
                    eventConsumer = this.eventConsumerManger.getEventConsumer(eventCode);
                }
                catch (Exception e) {
                    log.error("Es\u540c\u6b65\u6d88\u8d39\u6839\u636e\u4e8b\u4ef6\u7f16\u7801\u83b7\u53d6\u4e8b\u4ef6\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                    return ProxyConsumerStatus.RECONSUME_LATER;
                }
                List<IUocEsSyncQryEventReqBo> eventReqBos = eventConsumer.parseMap(paramMap);
                eventReqBos = this.validateArg(eventReqBos);
                log.info("ES\u6d88\u8d39\u8005\u68c0\u9a8c\u901a\u8fc7\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(eventReqBos));
                if (null == eventReqBos || !ObjectUtil.isNotEmpty(eventReqBos)) continue;
                for (IUocEsSyncQryEventReqBo eventReqBo : eventReqBos) {
                    List saveDataList;
                    List updateDataList;
                    if (!ObjectUtil.isNotEmpty((Object)eventReqBo.getIndexName())) continue;
                    String indexName = eventReqBo.getIndexName();
                    List<IUocEsSyncQryReqBo> dataList = eventReqBo.getDataList();
                    if (CollectionUtils.isEmpty(dataList)) continue;
                    ConcurrentMap<Integer, List<IUocEsSyncQryReqBo>> dataMap = dataList.stream().collect(Collectors.groupingByConcurrent(IUocEsSyncQryReqBo::getOpFlag));
                    List delDataList = (List)dataMap.get(UocConstant.ES_SYNC_OP_FLAG.DELETE);
                    if (!CollectionUtils.isEmpty((Collection)delDataList)) {
                        delDataList.forEach(syncQryReqBo -> {
                            UocEsSyncManagerSaveDataReqBo delDataReqBo = new UocEsSyncManagerSaveDataReqBo();
                            delDataReqBo.setOrderId(syncQryReqBo.getOrderId());
                            delDataReqBo.setObjId(syncQryReqBo.getObjId());
                            delDataReqBo.setIndexName(indexName);
                            delDataReqBo.setObjType(syncQryReqBo.getObjType());
                            delDataReqBo.setJsonObj(syncQryReqBo.getJsonObj());
                            log.info("\u540c\u6b65\u6570\u636e\u5220\u9664\u53c2\u6570\u5165\u53c2:" + JSON.toJSONString((Object)delDataReqBo));
                            try {
                                this.SyncManager.deleteData(delDataReqBo);
                            }
                            catch (Exception e) {
                                log.error("Es\u540c\u6b65\u6570\u636e\u5220\u9664\u53c2\u6570\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                            }
                        });
                    }
                    if (!CollectionUtils.isEmpty((Collection)(updateDataList = (List)dataMap.get(UocConstant.ES_SYNC_OP_FLAG.UPDATE)))) {
                        updateDataList.forEach(syncQryReqBo -> {
                            UocEsSyncManagerSaveDataReqBo updateDataReqBo = new UocEsSyncManagerSaveDataReqBo();
                            updateDataReqBo.setOrderId(syncQryReqBo.getOrderId());
                            updateDataReqBo.setObjId(syncQryReqBo.getObjId());
                            updateDataReqBo.setObjType(syncQryReqBo.getObjType());
                            updateDataReqBo.setJsonObj(syncQryReqBo.getJsonObj());
                            updateDataReqBo.setIndexName(indexName);
                            log.info("\u540c\u6b65\u6570\u636e\u66f4\u65b0\u53c2\u6570\u5165\u53c2:" + JSON.toJSONString((Object)updateDataReqBo));
                            try {
                                this.SyncManager.updateData(updateDataReqBo);
                            }
                            catch (Exception e) {
                                log.error("Es\u540c\u6b65\u6570\u636e\u66f4\u65b0\u53c2\u6570\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                            }
                        });
                    }
                    if (CollectionUtils.isEmpty((Collection)(saveDataList = (List)dataMap.get(UocConstant.ES_SYNC_OP_FLAG.SAVE)))) continue;
                    saveDataList.forEach(syncQryReqBo -> {
                        UocEsSyncManagerSaveDataReqBo saveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
                        saveDataReqBo.setOrderId(syncQryReqBo.getOrderId());
                        saveDataReqBo.setObjId(syncQryReqBo.getObjId());
                        saveDataReqBo.setObjType(syncQryReqBo.getObjType());
                        saveDataReqBo.setJsonObj(syncQryReqBo.getJsonObj());
                        saveDataReqBo.setIndexName(indexName);
                        log.info("\u540c\u6b65\u6570\u636e\u4fdd\u5b58\u53c2\u6570\u5165\u53c2:" + JSON.toJSONString((Object)saveDataReqBo));
                        try {
                            this.SyncManager.saveData(saveDataReqBo);
                        }
                        catch (Exception e) {
                            log.error("Es\u540c\u6b65\u6570\u636e\u4fdd\u5b58\u53c2\u6570\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                        }
                    });
                }
            }
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private List<IUocEsSyncQryEventReqBo> validateArg(List<IUocEsSyncQryEventReqBo> reqBo) {
        if (ObjectUtil.isNotEmpty(reqBo) && reqBo == null) {
            return null;
        }
        ArrayList<IUocEsSyncQryEventReqBo> iUocEsSyncQryEventReqBos = new ArrayList<IUocEsSyncQryEventReqBo>(reqBo.stream().collect(Collectors.toMap(IUocEsSyncQryEventReqBo::getIndexName, a -> a, (o1, o2) -> {
            if (ObjectUtil.isNotEmpty((Object)o1.getIndexName())) {
                if (!CollectionUtils.isEmpty(o1.getDataList()) || !CollectionUtils.isEmpty(o2.getDataList())) {
                    ArrayList<IUocEsSyncQryReqBo> dataList = new ArrayList<IUocEsSyncQryReqBo>();
                    if (!CollectionUtils.isEmpty(o1.getDataList())) {
                        for (IUocEsSyncQryReqBo iUocEsSyncQryReqBo : o1.getDataList()) {
                            if (!ObjectUtil.isNotEmpty((Object)iUocEsSyncQryReqBo.getOrderId()) || !ObjectUtil.isNotEmpty((Object)iUocEsSyncQryReqBo.getObjId())) continue;
                            dataList.add(iUocEsSyncQryReqBo);
                        }
                    }
                    if (!CollectionUtils.isEmpty(o2.getDataList())) {
                        for (IUocEsSyncQryReqBo iUocEsSyncQryReqBo : o2.getDataList()) {
                            if (!ObjectUtil.isNotEmpty((Object)iUocEsSyncQryReqBo.getOrderId()) || !ObjectUtil.isNotEmpty((Object)iUocEsSyncQryReqBo.getObjId())) continue;
                            dataList.add(iUocEsSyncQryReqBo);
                        }
                    }
                    o1.setDataList(dataList);
                    return o1;
                }
                return null;
            }
            return null;
        })).values());
        for (IUocEsSyncQryEventReqBo iUocEsSyncQryEventReqBo : iUocEsSyncQryEventReqBos) {
            iUocEsSyncQryEventReqBo.setDataList(iUocEsSyncQryEventReqBo.getDataList().stream().distinct().collect(Collectors.toList()));
        }
        return iUocEsSyncQryEventReqBos;
    }
}

