package com.tydic.dyc.oc.config;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 标题:UocIndexConfig
 * 说明:
 * 时间:2022/3/11 10:56
 * 作者:田桂银
 */
@Component
@Data
@EqualsAndHashCode(callSuper=false)
public class UocIndexConfig {

    /**
     * 订单索引
     */
    @Value("${uoc.index.orderIndex:oc_order}")
    private String orderIndex;

    /**
     * 销售单索引
     */
    @Value("${uoc.index.saleOrderIndex:oc_sale}")
    private String saleOrderIndex;

    /**
     * 执行单索引
     */
    @Value("${uoc.index.implOrderIndex:oc_impl}")
    private String implOrderIndex;

    /**
     * 发货单索引
     */
    @Value("${uoc.index.shipOrderIndex:oc_ship}")
    private String shipOrderIndex;

    /**
     * 售后单索引
     */
    @Value("${uoc.index.afOrderIndex:oc_af}")
    private String afOrderIndex;

    /**
     * 验收单索引
	 */
	@Value("${uoc.index.inspOrderIndex:oc_insp}")
	private String inspOrderIndex;

	/**
	 * 变更单索引
	 */
	@Value("${uoc.index.chngOrderIndex:oc_chng}")
	private String chngOrderIndex;

	/**
	 * 代办索引
	 */
	@Value("${uoc.index.todoIndex:oc_todo}")
	private String todoIndex;

	/**
	 * 成交服务费索引
	 */
	@Value("${uoc.index.transactionIndex:oc_transaction}")
	private String transactionIndex;

	/**
	 * 代办索引删除
	 */
	@Value("${uoc.index.todoIndex:oc_todo_delete}")
	private String todoIndexDelete;

	/**
	 * 审批单索引
	 */
	@Value("${uoc.index.approvalOrderIndex:oc_approval}")
	private String approvalOrderIndex;

	/**
	 * 索引不存在时，报错内容包含，用这个创建
	 */
	public static final String INDEX_EXCEPTION = "index_not_found_exception";

}


