package com.tydic.dyc.oc.model.bargaining.impl;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQryBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingBo;
import com.tydic.dyc.oc.repository.UocBargainingRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class IUocBargainingModelImpl implements IUocBargainingModel {
    @Autowired
    private UocBargainingRepository uocBargainingRepository;
    @Override
    public List<UocBargainingBo> getListBargaining(UocBargainingQryBo uocBargainingQryBo) {
        if (null == uocBargainingQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocBargainingRepository.qryListBargaining(uocBargainingQryBo);
    }
}
