package com.tydic.dyc.oc.model.order.sub;



import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocOrderTaskInst
 * 说明:订单任务实例
 * 时间:2022-02-21 19:10
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrderTaskInst implements Serializable {
	private static final long serialVersionUID = 3249178701210943771L;

	//id")
	private Long id;

	//订单id")
	private Long orderId;

	//任务实例id")
	private String taskInstId;

	//流程实例id")
	private String procInstId;

	//流程key定义")
	private String procDefId;

	//单据id")
	private Long objId;

	//单据类型:1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单     99.其他")
	private Integer objType;

	//所在环节")
	private String procState;

	//创建时间")
	private Date createTime;

	//完结标志0未完结1已完结")
	private Integer finishTag;

	//完成时间")
	private Date finishTime;

	//表单")
	private String formUrl;
	//删除标志1已删除")
	private Integer delTag;

	//ids")
	private List<Long> ids;

	//加签标识 0 ：环节任务   1：前加签任务  2：后加签任务  3：存在后加签任务")
	private Integer taskSignTag;

	//处理结果")
	private Integer dealResult;

	//处理备注")
	private String dealRemark;
	//处理人ID")
	private String dealOperId;

	//处理人姓名")
	private String dealOperName;




}
