package com.tydic.dyc.oc.model.payorder.sub;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题：UocOrderShouldPayDo
 * 说明：订单应付单
 * 时间：2022/4/2 14:00
 * 作者： 周中贤
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrderShouldPay implements Serializable {
    private static final long serialVersionUID = 5808288523259412303L;

    //应付ID")
    private Long shouldPayId;

    //应付类型1：账期应付：2：预付款应付；3：成交服务费应付；4：平台使用费应付；5：到货款应付；6：验收款应付；7：质保金应付；")
    private Integer shouldPayType;

    //付款方式 0:预付款 2:账期支付")
    private Integer payType;

    //订单ID")
    private Long orderId;

    //单据ID")
    private Long objectId;

    //订单单据类型,1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单 8验收单  9审批单   99.其他")
    private Integer objectType;

    //订单单据编码")
    private String objectNo;

    //应付金额")
    private BigDecimal shouldPayAmount;

    //已付金额")
    private BigDecimal paidAmount;

    //退款金额")
    private BigDecimal backAmount;

    //是否支付完成：0：未支付；1：支付完成")
    private Integer isPayCompleted;

    //结算应付ID")
    private Long fscShouldPayId;

    //应付日期")
    private Date shouldPayDate;

    //付款方ID")
    private Long payerId;

    //付款方名称")
    private String payerName;

    //收款方ID")
    private Long payeeId;

    //收款方名称")
    private String payeeName;

    //合同id")
    private String contractId;

    //合同编号")
    private String contractNo;

    //违约金")
    private BigDecimal penalty;

    //违约金比例")
    private BigDecimal penaltyRatio;

    //应该推送时间")
    private Date shouldPushTime;

    //实际推送时间")
    private Date actualPushTime;

    //支付配置ID")
    private Long payConfId;

    //支付金额类型")
    private Integer payFeeType;

    //创建时间")
    private Date createTime;

    //创建人")
    private String createOperName;

    //创建工号")
    private String createOperId;

    //更新时间")
    private Date updateTime;

    //更新工号")
    private String updateOperId;

    //更新人")
    private String updateOperName;

    //删除标志1已删除")
    private Integer delTag;

    //单据id集合")
    private List<Long> objectIdList;
}
