package com.tydic.dyc.oc.service.bargaining;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQryBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocBargainingCreateResultBO;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingCreateResultReqBO;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingCreateResultRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题:订单领域服务-议价单申请结果查询服务实现
 * 说明:
 * 时间:2023/7/26 15:19
 * 作者:Dum
 */
@HTServiceImpl
public class UocQryBargainingCreateResultServiceImpl implements UocQryBargainingCreateResultService{
    @Autowired
    private IUocBargainingModel uocBargainingModel;
    /**
     * 议价单申请结果查询服务
     */
    @Override
    public UocQryBargainingCreateResultRspBO qryBargainingCreateResult(UocQryBargainingCreateResultReqBO uocQryBargainingCreateResultReqBO) {
        validatebarg(uocQryBargainingCreateResultReqBO);
        UocQryBargainingCreateResultRspBO resultRspBO = new UocQryBargainingCreateResultRspBO();
        UocBargainingQryBo uocBargainingQryBo =new UocBargainingQryBo();
            uocBargainingQryBo.setBargainingParentId(uocQryBargainingCreateResultReqBO.getBargainingParentId());
            uocBargainingQryBo.setBargainingOperId(String.valueOf(uocQryBargainingCreateResultReqBO.getUserId()));
            uocBargainingQryBo.setPurOrgId(uocQryBargainingCreateResultReqBO.getOrgId() != null ? uocQryBargainingCreateResultReqBO.getOrgId().toString() : null);
        List<UocBargainingBo> uocBargainingBoList = uocBargainingModel.getListBargaining(uocBargainingQryBo);
        if (!CollectionUtils.isEmpty(uocBargainingBoList)) {
            for (UocBargainingBo uocBargainingBo : uocBargainingBoList) {
                UocBargainingCreateResultBO createResultBO = new UocBargainingCreateResultBO();
                createResultBO.setBargainingId(uocBargainingBo.getBargainingId());
                createResultBO.setPurOrgId(uocBargainingBo.getPurOrgId());
                createResultBO.setBargainingNo(uocBargainingBo.getBargainingNo());
                createResultBO.setSupplierName(uocBargainingBo.getSupplierName());
                createResultBO.setTotalPrice(uocBargainingBo.getTotalPrice());
                resultRspBO.getUocBargainingList().add(createResultBO);
            }
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "议价单查询结果为空");
        }
        return resultRspBO;
    }
    private void validatebarg(UocQryBargainingCreateResultReqBO reqBo) {

        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocQryBargainingCreateResultReqBO]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getBargainingParentId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【议价主单id】不能为空");
        }

    }
}
