package com.tydic.dyc.oc.model.insporder.qrybo;

import com.tydic.dyc.base.bo.BasePageReqBo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocInspOrderQryBo
 * 说明:验收单
 * 时间:2022-02-21 19:09
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocInspOrderQryBo extends BasePageReqBo {
	private static final long serialVersionUID =  -1500135445095031880L;

	//验收单id")
	private Long inspOrderId;


	//执行明细id")
	private Long implOrderItemId;

	//销售单id")
	private Long saleOrderId;

	//订单id")
	private Long orderId;

	//发货单编码")
	private String inspOrderNo;

	//外部发货单编码")
	private String inspOrderNoExt;

	//验收单名称")
	private String inspOrderName;

	//验收单类型")
	private Integer inspOrderType;

	//验收单状态")
	private String inspOrderState;

	//销售金额")
	private BigDecimal totalSaleFee;

	//采购金额")
	private BigDecimal totalPurchaseFee;

	//实付金额")
	private BigDecimal usedFee;

	//开票标识 0未开票 1已开票")
	private Integer invoiceTag;

	//流转状态")
	private String procState;

	//对账状态")
	private String checkState;

	//租户ID")
	private String tenantId;

	//竣工标志             1 竣工             0 在途")
	private Integer finishFlag;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//验收人电话")
	private String inspOperPhone;

	//验收人名字")
	private String inspOper;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//撤单时间")
	private Date cancelTime;

	//撤单时间 开始")
	private Date cancelTimeStart;

	//撤单时间 结束")
	private Date cancelTimeEnd;

	//撤单工号")
	private String cancelOperId;

	//撤单原因")
	private String cancelReason;

	//撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	//备注")
	private String remark;

	//竣工时间")
	private Date finishTime;

	//竣工时间 开始")
	private Date finishTimeStart;

	//竣工时间 结束")
	private Date finishTimeEnd;

	//逾期时间")
	private Date expTime;

	//逾期时间 开始")
	private Date expTimeStart;

	//逾期时间 结束")
	private Date expTimeEnd;

	

	//删除标志1已删除")
	private Integer delTag;

	//排序")
	private String orderBy;

}
