package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingItemQryBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingSkuListBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingSkuListReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingSkuListRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author DUM
 * @date 2023/8/8
 * @Version 1.0
 */
@HTServiceImpl
@Slf4j
public class UocQryBargainingSkuListServiceImpl implements UocQryBargainingSkuListService{
    @Autowired
    private IUocBargainingModel uocBargainingModel;
    @Override
    public UocQryBargainingSkuListRspBo qryBargainingSkuList(UocQryBargainingSkuListReqBo uocQryBargainingSkuListReqBo) {
        UocQryBargainingSkuListRspBo rspBo = UocRu.success(UocQryBargainingSkuListRspBo.class);
        rspBo.setPageNo(uocQryBargainingSkuListReqBo.getPageNo());
        //组织查询条件
        UocBargainingItemQryBo uocBargainingItemQryBo = new UocBargainingItemQryBo();
        uocBargainingItemQryBo.setBargainingNo(uocQryBargainingSkuListReqBo.getBargainingNo());
        uocBargainingItemQryBo.setSkuCode(uocQryBargainingSkuListReqBo.getSkuCode());
        uocBargainingItemQryBo.setSkuName(uocQryBargainingSkuListReqBo.getSkuName());
        uocBargainingItemQryBo.setSupId(uocQryBargainingSkuListReqBo.getSupplierId());
        uocBargainingItemQryBo.setBargainingOperName(uocQryBargainingSkuListReqBo.getBargainingOperName());
        uocBargainingItemQryBo.setCreateTimeStart(uocQryBargainingSkuListReqBo.getCreateTimeStart());
        uocBargainingItemQryBo.setCreateTimeEnd(uocQryBargainingSkuListReqBo.getCreateTimeEnd());
        uocBargainingItemQryBo.setPurOrgId(uocQryBargainingSkuListReqBo.getPurchaseId());
        uocBargainingItemQryBo.setPageNo(uocQryBargainingSkuListReqBo.getPageNo());
        uocBargainingItemQryBo.setPageSize(uocQryBargainingSkuListReqBo.getPageSize());
        BasePageRspBo<UocBargainingItem> itemBasePageRspBo = uocBargainingModel.getListPageBargainingItem(uocBargainingItemQryBo);
        if (CollectionUtils.isEmpty(itemBasePageRspBo.getRows())) {
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList<>(0));
        } else {
            rspBo.setTotal(itemBasePageRspBo.getTotal());
            rspBo.setRecordsTotal(itemBasePageRspBo.getRecordsTotal());
            List<UocQryBargainingSkuListBo> rows =  UocRu.jsl(itemBasePageRspBo.getRows(), UocQryBargainingSkuListBo.class);
            rspBo.setRows(rows);
        }
        return rspBo;
    }
}
