package com.tydic.dyc.oc.service.bargaining;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.bargaining.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 描述：按议价ID查询订单列表服务
 *
 * @author gaoqh646
 * @date 2023/8/7 9:54
 **/

@HTServiceImpl
@Slf4j
public class UocQryOrderListByBargainingIdServiceImpl implements UocQryOrderListByBargainingIdService {


    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocQryOrderListByBargainingIdRspBo qryOrderListByBargainingId(UocQryOrderListByBargainingIdReqBo reqBo) {
        verifyParam(reqBo);
        UocQryOrderListByBargainingIdRspBo resp = new UocQryOrderListByBargainingIdRspBo();
        List<UocSaleOrderDo> saleOrderListByBar = iUocSaleOrderModel.getSaleOrderListByBar(reqBo.getBargainingId());
        List<UocQryOrderListByBargainingBo> rspList = UocRu.jsl(saleOrderListByBar, UocQryOrderListByBargainingBo.class);
        resp.setOrderList(rspList);
        return resp;
    }

    private void verifyParam(UocQryOrderListByBargainingIdReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocQryOrderListByBargainingIdReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getBargainingId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[bargainingId]不能为空");
        }

    }
}
