package com.tydic.dyc.oc.model.saleorder.qrybo;

import com.tydic.dyc.base.bo.BasePageReqBo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocSaleOrderQryBo
 * 说明:销售订单
 * 时间:2022-02-21 19:11
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocSaleOrderQryBo extends BasePageReqBo {
	private static final long serialVersionUID =  -5093096787351635293L;

	//销售单id")
	private Long saleOrderId;

	//订单id")
	private Long orderId;

	//三方信息id")
	private Long stakeholderId;

	//销售单编码")
	private String saleOrderNo;

	//外部销售单编码")
	private String saleOrderNoExt;

	//销售单名称")
	private String saleOrderName;

	//销售单类型")
	private Integer saleOrderType;

	//订单状态")
	private String saleOrderState;

	//销售单单说明")
	private String saleOrderDesc;

	//订单来源  1 自营单品   2 电商导入   3 协议生成    ")
	private Integer orderSource;

	//支付类型")
	private Integer payMod;

	//支付方式")
	private String payType;

	//销售金额")
	private BigDecimal totalSaleFee;

	//采购金额")
	private BigDecimal totalPurchaseFee;

	//优惠金额")
	private BigDecimal totalActShareFee;

	//运费")
	private BigDecimal totalTransFee;

	//实付金额")
	private BigDecimal usedFee;

	//实付积分")
	private BigDecimal usedIntegral;

	//协议编号")
	private String agreementNo;

	//合同编号")
	private String contractNo;

	//支付状态")
	private Integer payState;

	//流转状态")
	private String procState;

	//税率")
	private String taxRate;

	//竣工标志             1 竣工             0 在途")
	private Integer finishFlag;

	//租户ID")
	private String tenantId;

	//送货时间")
	private Date sendTime;

	//送货时间 开始")
	private Date sendTimeStart;

	//送货时间 结束")
	private Date sendTimeEnd;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//撤单时间")
	private Date cancelTime;

	//撤单时间 开始")
	private Date cancelTimeStart;

	//撤单时间 结束")
	private Date cancelTimeEnd;

	//撤单工号")
	private String cancelOperId;

	//撤单原因")
	private String cancelReason;

	//撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	//竣工时间")
	private Date finishTime;

	//竣工时间 开始")
	private Date finishTimeStart;

	//竣工时间 结束")
	private Date finishTimeEnd;

	//逾期时间")
	private Date expTime;

	//逾期时间 开始")
	private Date expTimeStart;

	//逾期时间 结束")
	private Date expTimeEnd;

	//结算模式 2:撮合 1:贸易")
	private Integer modelSettle;

	//采购类别             1 物资             2 施工             3 服务             ")
	private Integer purchaseType;

	//创建人名称")
	private String createOperName;

	//更新人名称")
	private String updateOperName;

	//撤单人名称")
	private String cancelOperName;

    //供应商拒单人")
    private String rejectOperId;

    //供应商拒单人名称")
    private String rejectOperName;

    //供应商拒单原因")
    private String rejectReason;

    //供应商拒单时间")
    private Date rejectTime;

	//备注")
	private String remark;

	//删除标志1已删除")
	private Integer delTag;

	//排序")
	private String orderBy;

	//订单idList")
	private List<Long> orderIdList;
    
    //销售订单idList")
    private List<Long> saleOrderIdList;
}
