package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultByStateServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultByStateServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultServiceRspProcessDataBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@Slf4j
@HTServiceImpl
public class UocQryOrderCreateResultByStateServiceImpl implements UocQryOrderCreateResultByStateService{
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    /**
     * 订单创建结果查询
     *
     * @param reqBo
     */
    @Override
    public UocQryOrderCreateResultByStateServiceRspBo qryOrderCreateResult(UocQryOrderCreateResultByStateServiceReqBo reqBo) {
        //必输项校验
        validateArg(reqBo);
    
        UocQryOrderCreateResultByStateServiceRspBo rspBo = UocRu.success(UocQryOrderCreateResultByStateServiceRspBo.class);
        UocOrderDo qryOrderDo = new UocOrderDo();
        qryOrderDo.setOrderId(reqBo.getOrderId());
        UocOrderDo uocOrderDo = iUocOrderModel.qryOrderBy(qryOrderDo);
        if (ObjectUtil.isEmpty(uocOrderDo)) {
            return rspBo;
        }
    
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setOrderNo(uocOrderDo.getOrderNo());
        rspBo.setTotalSaleFee(uocOrderDo.getTotalSaleFee());
    
    
        //是否处理完成
        boolean processResult = true;
        UocSaleOrderDo qrySaleDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        List<UocSaleOrderDo> uocSaleOrderDos = iUocSaleOrderModel.qrySaleOrderList(qrySaleDo);
        //获取所有销售单对应的状态
        
        for (UocSaleOrderDo uocSaleOrderDo : uocSaleOrderDos) {
            UocQryOrderCreateResultServiceRspProcessDataBo resultDataBo = new UocQryOrderCreateResultServiceRspProcessDataBo();
    
            // 创建结果为0，表示该销售单仍在处理中
            if (UocConstant.CREATED_RESULT.PROCESSING.equals(uocSaleOrderDo.getCreatedResult())) {
                processResult = false;
            }
            
            if (ObjectUtil.isNotEmpty(uocSaleOrderDo.getCancelReason())
                    || UocStateConstants.SaleOrder.XS_QX_QX.equals(uocSaleOrderDo.getSaleOrderState())
                    || UocStateConstants.SaleOrder.XS_XD_SB.equals(uocSaleOrderDo.getSaleOrderState())
                    || (UocConstant.CREATED_RESULT.FAILED.equals(uocSaleOrderDo.getCreatedResult()))) {
                resultDataBo.setMsg(uocSaleOrderDo.getCancelReason());
                resultDataBo.setResultCode(3);
                resultDataBo.setResultDescription("失败");
        
                UocSaleOrderItemQryBo saleOrderItemQryBo = new UocSaleOrderItemQryBo();
                saleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
                List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(saleOrderItemQryBo);
                resultDataBo.setCommodityInfo(UocRu.jsl(saleOrderItemList, UocGetSaleOrderDetailServiceRspItemBo.class));
                resultDataBo.setSupNo(uocSaleOrderDo.getStakeholder().getSupId());
                rspBo.getFailedList().add(resultDataBo);
            } else {
                resultDataBo.setResultCode(1);
                resultDataBo.setResultDescription("成功");
//                rspBo.getSuccessList().add(resultDataBo);
            }
        }
    
        rspBo.setProcessResult(processResult);
    
        return rspBo;
    }
    
    /*
     * @Author lsl
     * @Description //TODO 入参必输项校验
     * @Date 16:41 2023/7/29
     * @Param [reqBo]
     * @return void
     */
    private void validateArg(UocQryOrderCreateResultByStateServiceReqBo reqBo) {
        
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocQryOrderCreateResultByStateServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单id【orderId】不能为空");
        }
        
    }
}
