package com.tydic.dyc.oc.model.order.qrybo;

import com.tydic.dyc.base.bo.BasePageReqBo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 标题:UocOrderBusiOperRecordQryBo
 * 说明:订单业务操作记录领域对象
 * 时间:2022-02-21 19:10
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocOrderBusiOperRecordQryBo extends BasePageReqBo {
	private static final long serialVersionUID =  -1903432262941571382L;

	private Long id;

	//记录类型                          1、流程操作记录：                1）、task_id,task_name填写uoc_ord_task中对应task_id,task_name                2）、oper_type_id填写uoc_ord_task中tache_code             2、单据操作记录：                1）、task_id,task_name不填                2）、oper_type_id填写定义的枚举值（数据字典:task_deal_code）,oper_type_id填写枚举值对应的中文说明                                          ")
	private Integer recordType;

	//单据id      单据类型为1=订单时，不填")
	private Long objId;

	//单据类型:1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单     99.其他")
	private Integer objType;

	//订单id")
	private Long orderId;

	//切面流水")
	private String secSn;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//处理时间")
	private Date dealTime;

	//处理时间 开始")
	private Date dealTimeStart;

	//处理时间 结束")
	private Date dealTimeEnd;

	//处理工号")
	private String dealOperId;

	//处理人名称")
	private String dealOperName;

	//处理人角色")
	private String dealRole;

	//处理人部门id")
	private String dealDeptId;

	//处理人部门")
	private String dealDeptName;

	//处理人公司id")
	private String dealCompId;

	//处理人公司")
	private String dealCompName;

	//流程任务id")
	private String taskId;

	//流程任务名称")
	private String taskName;

	//处理类型id                          见数据字典：task_deal_type")
	private String dealTypeId;

	//处理类型名称")
	private String dealTypeName;

	//处理动作编码                          见数据字典：task_deal_code")
	private String dealCode;

	//处理动作名称")
	private String dealName;

	//处理原因                          见数据字典：task_deal_reason")
	private String dealReason;

	//处理描述")
	private String dealDesc;

	//处理人岗位ID")
	private String dealPostId;

	//处理人岗位名称")
	private String dealPostName;

	//主机ip地址")
	private String ipAddress;

	//订单编号")
	private String orderNo;

	//排序")
	private String orderBy;

}
