package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingQuotationDo;
import com.tydic.dyc.oc.service.bargaining.bo.UocResolveBargainingApplyReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocResolveBargainingApplyRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/** 发送三方电商议价申请出参结果解析入库
 * @author DUM
 * @date 2023/8/12
 * @Version 1.0
 */
@HTServiceImpl
@Slf4j
public class UocResolveBargainingApplyServiceImpl implements UocResolveBargainingApplyService{
    @Autowired
    private IUocBargainingModel uocBargainingModel;
    @Override
    public UocResolveBargainingApplyRspBo dealBargainingApply(UocResolveBargainingApplyReqBo reqBo) {
        if(UocConstant.CREATED_RESULT.FAILED.equals(reqBo.getCreatedResult())) {
            UocBargainingDo uocBargainingDo = new UocBargainingDo();
            uocBargainingDo.setBargainingId(reqBo.getBargainingId());
            UocBargainingDo uocBargainingQryDo = uocBargainingModel.qryBargainingBy(uocBargainingDo);
            if (UocStateConstants.BARGAINING_STATES.YJ_BJZ.equals(uocBargainingQryDo.getBargainingState())) {
                UocBargainingDo bargainingDo = new UocBargainingDo();
                bargainingDo.setUpdateTime(new Date());
                bargainingDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
                bargainingDo.setUpdateOperName(reqBo.getName());
                bargainingDo.setCancelTime(new Date());
                bargainingDo.setCancelReason(reqBo.getCancelReason());
                bargainingDo.setCancelOperName(reqBo.getName());
                bargainingDo.setCancelOperId(String.valueOf(reqBo.getUserId()));
                bargainingDo.setBargainingState(UocStateConstants.BARGAINING_STATES.YJ_YZZ); //已终止
                bargainingDo.setBargainingId(reqBo.getBargainingId());
                uocBargainingModel.updateBargaining(bargainingDo);
            } else if (UocStateConstants.BARGAINING_STATES.YJ_YBJ.equals(uocBargainingQryDo.getBargainingState())) {
                UocBargainingQuotationDo uocBargainingQuotationDo = new UocBargainingQuotationDo();
                uocBargainingQuotationDo.setBargainingId(reqBo.getBargainingId());
                uocBargainingQuotationDo.setQuotationId(reqBo.getQuotationId());
                uocBargainingQuotationDo.setQuotationStatus("3");
                uocBargainingQuotationDo.setQuotationReason(reqBo.getCancelReason());
                uocBargainingModel.updateQuotation(uocBargainingQuotationDo);
            }
        }
        //发起成功
        UocBargainingQuotationDo uocBargainingQuotationDo = new UocBargainingQuotationDo();
        uocBargainingQuotationDo.setBargainingId(reqBo.getBargainingId());
        uocBargainingQuotationDo.setQuotationId(reqBo.getQuotationId());
        uocBargainingQuotationDo.setQuotationStatus("1");
        uocBargainingModel.updateQuotation(uocBargainingQuotationDo);
        return UocRu.success(UocResolveBargainingApplyRspBo.class);
    }
}
