package com.tydic.dyc.oc.model.shiporder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.UocShipOrderRepository;
import com.tydic.dyc.oc.utils.IdUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * 标题:UocShipOrderModelImpl
 * 说明:发货单
 * 时间:2022/2/23 14:03
 * 作者:罗有
 */

@Service
public class UocShipOrderModelImpl implements IUocShipOrderModel {

    @Autowired
    private UocShipOrderRepository uocShipOrderRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;

    /**
     * 创建发货单
     */
    @Override
    public void createShipOrder(UocShipOrderDo uocShipOrderDo) {
        valDo(uocShipOrderDo);
        uocShipOrderRepository.createShipOrder(uocShipOrderDo);
        uocCommonRepository.addBatchOrderAccessory(uocShipOrderDo.getOrderAccessoryBoList());
    }

    /**
     * 到货确认
     */
    @Override
    public void arrivaConfirm(UocShipOrderDo uocShipOrderDo) {
        valDo(uocShipOrderDo);
        if (null == uocShipOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
        if (!StringUtils.isBlank(uocShipOrderDo.getReceiverUser())
                || !StringUtils.isBlank(uocShipOrderDo.getReceiverRemark())
                || !StringUtils.isBlank(uocShipOrderDo.getReceiverContact())
                || null != uocShipOrderDo.getReceiverTime()) {
            uocShipOrderRepository.modifyBatchShipOrderArrivaRefuse(uocShipOrderDo);
        }
        uocShipOrderRepository.modifyArrivaShipOrderItem(uocShipOrderDo);
        uocCommonRepository.addBatchOrderAccessory(uocShipOrderDo.getOrderAccessoryBoList());
    }

    /**
     * 到货拒收
     */
    @Override
    public void arrivaRefuse(UocShipOrderDo uocShipOrderDo) {
        valDo(uocShipOrderDo);
        if (null == uocShipOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
        if (!StringUtils.isBlank(uocShipOrderDo.getReceiverUser())
                || !StringUtils.isBlank(uocShipOrderDo.getReceiverRemark())
                || !StringUtils.isBlank(uocShipOrderDo.getReceiverContact())
                || null != uocShipOrderDo.getReceiverTime()) {
            uocShipOrderRepository.modifyBatchShipOrderArrivaRefuse(uocShipOrderDo);
        }
        uocShipOrderRepository.modifyRefuseShipOrderItem(uocShipOrderDo);
        uocCommonRepository.addBatchOrderAccessory(uocShipOrderDo.getOrderAccessoryBoList());
    }

    @Override
    public UocShipOrderDo getListShipOrderItem(UocShipOrderItemQryBo uocShipOrderItemQryBo) {
        if (null == uocShipOrderItemQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocShipOrderRepository.getListShipOrderItem(uocShipOrderItemQryBo);
    }

    @Override
    public void modifyShipOrderMain(UocShipOrderDo uocShipOrderDo) {
        valDo(uocShipOrderDo);
        uocShipOrderRepository.modifyShipOrderMain(uocShipOrderDo);
        uocCommonRepository.addBatchOrderAccessory(uocShipOrderDo.getOrderAccessoryBoList());
    }

    @Override
    public void modifyShipOrderItemInspCount(UocShipOrderDo uocShipOrderDo) {
        valDo(uocShipOrderDo);
        if(CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "发货明细列表不能为空");
        }
        uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
            if(null == uocShipOrderItem.getShipOrderItemId()){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "发货明细ID不能为空");
            }
            if(null == uocShipOrderItem.getInspCount()){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "发货明细验收数量不能为空");
            }
        });
        uocShipOrderRepository.modifyBatchShipOrderItemInspCount(uocShipOrderDo);
    }

    @Override
    public UocShipOrderDo getShipOrderById(UocShipOrderQryBo uocShipOrderQryBo) {
        if (null == uocShipOrderQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocShipOrderQryBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        return uocShipOrderRepository.getShipOrderById(uocShipOrderQryBo);
    }

    @Override
    public List<UocShipOrderDo> getListShipOrder(UocShipOrderQryBo uocShipOrderQryBo) {
        if (null == uocShipOrderQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
//        if (null == uocShipOrderQryBo.getOrderId()) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID不能为空");
//        }
        return uocShipOrderRepository.getListShipOrder(uocShipOrderQryBo);
    }

    @Override
    public UocShipOrderDo getShipOrderNo(UocShipOrderDo uocShipOrderDo) {
        if (null == uocShipOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocShipOrderDo.getOrderSource()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参来源不能为空");
        }
        String orderNo = uocCommonRepository.getOrderNoSingle(UocObjNoConstants.ORDER_SHIP_NO + "_" + uocShipOrderDo.getOrderSource());
        uocShipOrderDo.setShipOrderNo(orderNo);
        return uocShipOrderDo;
    }

    @Override
    public void modifyShipOrderItemChngingCount(UocShipOrderDo uocShipOrderDo) {
        valDo(uocShipOrderDo);
        if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "发货明细不能为空");
        }
        uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
            if (null == uocShipOrderItem.getShipOrderItemId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "发货明细ID为空");
            }
            if (null == uocShipOrderItem.getChngingCount()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "变更数量在途不能为空");
            }

        });
        uocShipOrderRepository.modifyShipOrderItemChngingCount(uocShipOrderDo);
    }

    @Override
    public void modifyItemReturnCountConfirm(UocShipOrderDo uocShipOrderDo) {
        if (null == uocShipOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (CollectionUtils.isEmpty(uocShipOrderDo.getOrderIdList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单id集合不能为空");
        }
        if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemIdList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参发货明细单id集合不能为空");
        }
        uocShipOrderRepository.modifyItemReturnCountConfirm(uocShipOrderDo);
    }

    @Override
    public void  modifyItemChngCountRefuse(UocShipOrderDo uocShipOrderDo) {
        if (null == uocShipOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemIdList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参发货明细id不能为空");
        }
        if (CollectionUtils.isEmpty(uocShipOrderDo.getOrderIdList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单id不能为空");
        }
        uocShipOrderRepository.modifyItemChngCountRefuse(uocShipOrderDo);
    }

    @Override
    public void updateShipStatusAndProCode(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderQryBo qryBo = new UocShipOrderQryBo();
        qryBo.setOrderId(uocShipOrderDo.getOrderId());
        qryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        UocShipOrderDo shipOrderDo = getShipOrderById(qryBo);
        if (ObjectUtil.isEmpty(shipOrderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SHIP_UPDATE_STATE_ERROR, "该发货单" + uocShipOrderDo.getShipOrderId() + "不存在");
        }

        //记录变更日志
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(uocShipOrderDo.getShipOrderId());
        uocOrderStateChgLog.setOrderId(uocShipOrderDo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        uocOrderStateChgLog.setOldState(shipOrderDo.getShipOrderState());
		uocOrderStateChgLog.setNewState(uocShipOrderDo.getShipOrderState());
		uocOrderStateChgLog.setChgTime(new Date());
		uocOrderStateChgLog.setOperId(uocShipOrderDo.getUpdateOperId());

		//调用通用repository，创建状态变更日志
		uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
		//更新状态
		uocShipOrderRepository.updateShipStatusAndProCode(uocShipOrderDo);
	}

	@Override
	public void addShipOrderMap(UocShipOrderDo uocShipOrderDo) {
		valDo(uocShipOrderDo);
		uocShipOrderRepository.addShipOrderMap(uocShipOrderDo);
	}

	@Override
	public void updateBatchValue(UocShipOrderDo uocShipOrderDo) {
		valDo(uocShipOrderDo);
		uocShipOrderRepository.updateBatchValue(uocShipOrderDo);
	}

	@Override
	public void updateInvalid(UocShipOrderDo uocShipOrderDo) {
		valDo(uocShipOrderDo);
		uocShipOrderRepository.updateInvalid(uocShipOrderDo);
	}

    @Override
    public void modifyShipOrderItemInspCountEqualArrivalCount(UocShipOrderDo uocShipOrderDo) {
        uocShipOrderRepository.modifyShipOrderItemInspCountEqualArrivalCount(uocShipOrderDo);
    }

    private void valDo(UocShipOrderDo uocShipOrderDo) {
		if (null == uocShipOrderDo) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
		}
		if (null == uocShipOrderDo.getOrderId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID不能为空");
		}
	}

    @Override
    public void modifyItemArriveCountConfirm(UocShipOrderDo uocShipOrderDo) {
        uocShipOrderRepository.modifyItemArriveCountConfirm(uocShipOrderDo);
    }

    @Override
    public void modifyItemRefuseCountConfirm(UocShipOrderDo uocShipOrderDo) {
        uocShipOrderRepository.modifyItemRefuseCountConfirm(uocShipOrderDo);

    }
    
    @Override
    public void modifyShipArrivtime(UocShipOrderDo uocShipOrderDo) {
        uocShipOrderRepository.modifyShipArrivtime(uocShipOrderDo);
    }
    
    @Override
    public void modifyItemArriveCount(UocShipOrderDo uocShipOrderDo) {
        uocShipOrderRepository.modifyItemArriveCount(uocShipOrderDo);
    }

    @Override
    public void modifyShipOrderStatus(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderDo uocShipOrderDo1 = new UocShipOrderDo();
        uocShipOrderDo1.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderDo1.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocShipOrderDo1.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocShipOrderRepository.modifyShipStatus(uocShipOrderDo1);
    }

    @Override
    public void modifyStatChngShipStatus(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderDo uocShipOrderDo1 = new UocShipOrderDo();
        uocShipOrderDo1.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderDo1.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocShipOrderRepository.modifyStatChngShipStatus(uocShipOrderDo1);
    }

    @Override
    public void modifyShipOrderItemAfterServingCount(UocShipOrderItem uocShipOrderItem) {
        uocShipOrderRepository.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
    }

    @Override
    public List<UocShipOrderItem> getShipOrderItemList(UocShipOrderItemQryBo uocShipOrderItemQryBo) {
        return uocShipOrderRepository.getShipOrderItem(uocShipOrderItemQryBo);
    }

    @Override
    public void modifyShipOrderItemReturningCount(UocShipOrderItem uocShipOrderItem) {
        uocShipOrderRepository.modifyShipOrderItemReturningCount(uocShipOrderItem);
    }
    
    @Override
    public List<UocShipOrderDo> getCheckVoterOrders(UocShipOrderDo record) {
        return uocShipOrderRepository.getCheckVoterOrders(record);
    }
    
    @Override
    public List<UocShipOrderDo> getCheckRefuseOrders(UocShipOrderDo record) {
        return uocShipOrderRepository.getCheckRefuseOrders(record);
    }

    @Override
    public void batchSyncShip() {
        uocShipOrderRepository.batchSyncShip();
    }

}
