package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.transactionservice.UocCancelSaleOrderConfirmOrRefuseTransaction;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderConfirmOrRefuseRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述: 〈领域服务-销售单取消申请同意/拒绝（单条）实现〉
 * @author : yuhao
 * @date : 2022/8/1 11:06
 */
@HTServiceImpl
public class UocCancelSaleOrderConfirmOrRefuseServiceImpl implements UocCancelSaleOrderConfirmOrRefuseService {

    @Autowired
    private UocCancelSaleOrderConfirmOrRefuseTransaction uocCancelSaleOrderConfirmOrRefuseTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocCancelSaleOrderConfirmOrRefuseRspBo cancelSaleOrderConfirmOrRefuse(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo) {
        UocCancelSaleOrderConfirmOrRefuseRspBo rspBo = uocCancelSaleOrderConfirmOrRefuseTransaction.cancelSaleOrderConfirmOrRefuse(reqBo);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo, UocCancelSaleOrderConfirmOrRefuseRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleOrderBo = new SyncEsRunnableBo();
        saleOrderBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleOrderBo.setOrderId(reqBo.getOrderId());
        saleOrderBo.setObjId(reqBo.getSaleOrderId());
        saleOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleOrderBo);

        SyncEsRunnableBo chngBo = new SyncEsRunnableBo();
        chngBo.setIndexName(uocIndexConfig.getChngOrderIndex());
        chngBo.setOrderId(reqBo.getOrderId());
        chngBo.setObjId(reqBo.getChngOrderId());
        chngBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(chngBo);

        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}
