/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UocEsSyncBargaining
implements IUocEsSync {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncBargaining.class);
    protected static final List<String> pCodeList = ListUtil.list((boolean)false);
    @Autowired
    private IUocBargainingModel uocBargainingModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public String indexName() {
        return this.uocIndexConfig.getBargainingIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        log.info("syncSyncBargainingReq,{}", (Object)JSON.toJSONString((Object)reqBo));
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getObjId());
        UocBargainingDo bargainingObject = this.getBargainingObject(reqBo);
        if (Objects.isNull(bargainingObject)) {
            return rspBo;
        }
        UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = this.getProcInst(reqBo, false, UocDicConstant.OBJ_TYPE.BARGAIN);
        Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        JSONObject bargainingObj = JSON.parseObject((String)JSON.toJSONString((Object)bargainingObject));
        bargainingObj.put("busiTaskList", (Object)busiProcInst.getTaskList());
        rspBo.setJsonObj(bargainingObj);
        this.translateProperties(rspBo, dictionaryMap);
        log.info("\u8bae\u4ef7\u5355es\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)rspBo));
        return rspBo;
    }

    private static void initialize() {
        pCodeList.add("UOC_BARGAINING_STATE");
    }

    private void translateProperties(IUocEsSyncQryRspBo rspBo, Map<String, Map<String, String>> dictionaryMap) {
        JSONObject jsonObj = rspBo.getJsonObj();
        if (ObjectUtil.isNotEmpty(dictionaryMap) && ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_BARGAINING_STATE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"bargainingState"))) {
            String bargainingState = jsonObj.getString("bargainingState");
            jsonObj.put("bargainingStateStr", (Object)dictionaryMap.get("UOC_BARGAINING_STATE").get(bargainingState));
        }
    }

    private UocBargainingDo getBargainingObject(IUocEsSyncQryReqBo reqBo) {
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setBargainingId(reqBo.getOrderId());
        return this.uocBargainingModel.qryBargaining(uocBargainingDo);
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(IUocEsSyncQryReqBo reqBo, Boolean isAudit, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        procInstQryBo.setObjId(reqBo.getObjId());
        procInstQryBo.setObjType(objType);
        procInstQryBo.setOrderId(reqBo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            ArrayList<Integer> finishTagList = new ArrayList<Integer>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            taskInstQryBo.setFinishTagList(finishTagList);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                });
                procInst.setProcState(uocOrderTaskInsts.get(0).getProcState());
                procInst.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }

    static {
        UocEsSyncBargaining.initialize();
    }
}

