/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdInvoiceQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdInvoice;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailService;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspAgreementInfoBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspInspOrderInfoBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspInspOrderItemInfoBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspInvoiceBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspReceiverAddressBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspShipOrderInfoBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspShipOrderItemBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspShouldPayOrderBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspStakeholderBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspVerifyInfoBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderAuditBO;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailService"})
public class UocGetSaleOrderDetailServiceImpl
implements UocGetSaleOrderDetailService {
    private static final Logger log = LoggerFactory.getLogger(UocGetSaleOrderDetailServiceImpl.class);
    protected static final List<String> pCodeList = ListUtil.list((boolean)false);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    private static final String LINE = "_";
    @Value(value="${uoc.obj_type.isSale:0}")
    private String isSale;
    @Value(value="${uoc.dataAchiveFlag:false}")
    private Boolean dataAchiveFlag;

    @PostMapping(value={"getSaleOrderDetail"})
    public UocGetSaleOrderDetailServiceRspBo getSaleOrderDetail(@RequestBody UocGetSaleOrderDetailServiceReqBo reqBo) {
        log.info("\u67e5\u8be2\u9500\u552e\u5355\u8be6\u60c5");
        this.validateParam(reqBo);
        ArrayList<UocBaseOrderAccessoryTypeDetailBo> accessoryDetailBoList = new ArrayList<UocBaseOrderAccessoryTypeDetailBo>();
        ArrayList<UocGetSaleOrderDetailServiceRspItemBo> uocGetSaleOrderDetailServiceRspItemBos = new ArrayList<UocGetSaleOrderDetailServiceRspItemBo>();
        ArrayList<UocGetSaleOrderDetailServiceRspShipOrderInfoBo> shipOrderInfo = new ArrayList<UocGetSaleOrderDetailServiceRspShipOrderInfoBo>();
        ArrayList<UocGetSaleOrderDetailServiceRspInspOrderInfoBo> inspOrderInfo = new ArrayList<UocGetSaleOrderDetailServiceRspInspOrderInfoBo>();
        UocSaleOrderDo saleOrderMainInfo = this.querySaleOrderMainInfo(reqBo, null);
        String dataAchiveTabSuffix = null;
        if (this.dataAchiveFlag.booleanValue() && Objects.isNull((Object)saleOrderMainInfo)) {
            dataAchiveTabSuffix = LINE + new SimpleDateFormat("yyyy").format((reqBo.getSaleOrderId() >> 22) + 1420041600000L);
            saleOrderMainInfo = this.querySaleOrderMainInfo(reqBo, dataAchiveTabSuffix);
        }
        if (saleOrderMainInfo == null) {
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u9500\u552e\u5355\u4e3b\u4f53\u4fe1\u606f\u5931\u8d25");
        }
        UocGetSaleOrderDetailServiceRspBo rspBo = UocRu.js((Object)saleOrderMainInfo, UocGetSaleOrderDetailServiceRspBo.class);
        if (null == rspBo.getTotalTransFee()) {
            rspBo.setTotalTransFee(BigDecimal.ZERO);
        }
        if (null != saleOrderMainInfo.getStakeholder()) {
            BeanUtils.copyProperties((Object)saleOrderMainInfo.getStakeholder(), (Object)rspBo);
            rspBo.setDistirbutionId(saleOrderMainInfo.getStakeholder().getSupId());
            rspBo.setDistirbutionName(saleOrderMainInfo.getStakeholder().getSupName());
            rspBo.setDistirbutionIdContactName(saleOrderMainInfo.getStakeholder().getSupRelaName());
            rspBo.setDistirbutionIdContactMobile(saleOrderMainInfo.getStakeholder().getSupRelaMobile());
            rspBo.setUocGetSaleOrderDetailServiceRspStakeholderBo(UocRu.js(saleOrderMainInfo.getStakeholder(), UocGetSaleOrderDetailServiceRspStakeholderBo.class));
            rspBo.setProId(saleOrderMainInfo.getStakeholder().getProId());
            rspBo.setPurUserId(saleOrderMainInfo.getStakeholder().getPurUserId());
        }
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        uocSaleOrderPayConfQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderPayConfQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocSaleOrderPayConf> saleOrderPayConfList = this.iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderPayConfList) && ObjectUtil.isNotEmpty(saleOrderPayConfList = saleOrderPayConfList.stream().filter(each -> ObjectUtil.notEqual((Object)each.getPayType(), (Object)UocDicConstant.PAY_TYPE.PAY_BY_PERIOD) && null != each.getPrePayFee() && null != each.getVerPayFee() && null != each.getPilPayFee() && null != each.getQuaPayFee()).collect(Collectors.toList()))) {
            UocSaleOrderPayConf payConf = saleOrderPayConfList.get(0);
            DecimalFormat df = new DecimalFormat("0%");
            BigDecimal divide = new BigDecimal(100);
            rspBo.setPayRatio("\u9884\u4ed8\u6b3e" + df.format(payConf.getPrePaySup().divide(divide, 2, 4)) + "-\u5230\u8d27\u6b3e" + df.format(payConf.getVerPaySup().divide(divide, 2, 4)) + "-\u9a8c\u6536\u6b3e" + df.format(payConf.getPilPaySup().divide(divide, 2, 4)) + "-\u8d28\u4fdd\u91d1" + df.format(payConf.getQuaPaySup().divide(divide, 2, 4)));
        }
        UocGetSaleOrderDetailServiceRspPorcBo procInst = this.getProcInst(saleOrderMainInfo, this.isSale, dataAchiveTabSuffix);
        rspBo.setProcInst(procInst);
        List<UocGetSaleOrderDetailServiceRspPorcBo> procTacheFinish = this.getProcTacheFinish(saleOrderMainInfo, dataAchiveTabSuffix);
        rspBo.setFinishTacheInfo(procTacheFinish);
        UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = this.getAuditProcInst(saleOrderMainInfo, UocDicConstant.OBJ_TYPE.SALE, dataAchiveTabSuffix);
        rspBo.setAuditProcInst(auditProcInst);
        UocOrderDo orderInfo = this.queryOrderInfo(saleOrderMainInfo.getOrderId(), dataAchiveTabSuffix);
        rspBo.setOrderNo(orderInfo.getOrderNo());
        rspBo.setOrderTime(orderInfo.getCreateTime());
        rspBo.setRemark(orderInfo.getRemark());
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderMainInfo.getOrderSource())) {
            UocGetSaleOrderDetailServiceRspAgreementInfoBo orderAgreement = this.queryOrderAgrInfo(saleOrderMainInfo.getOrderId(), saleOrderMainInfo.getAgrDataId(), dataAchiveTabSuffix);
            rspBo.setAgreementInfo(orderAgreement);
        }
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        uocChngOrderQryBo.setBusiTypeList(Arrays.asList(UocConstant.BUSI_TYPE.PRICE_CHG));
        uocChngOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocChngOrderDo> listChngOrder = this.iUocChngOrderModel.getListChngOrder(uocChngOrderQryBo);
        UocGetSaleOrderDetailServiceRspVerifyInfoBo orderVerifyInfo = new UocGetSaleOrderDetailServiceRspVerifyInfoBo();
        if (ObjectUtil.isNotEmpty(listChngOrder)) {
            orderVerifyInfo.setAdjustName(listChngOrder.get(0).getCreateOperName());
            orderVerifyInfo.setAdjustTime(listChngOrder.get(0).getCreateTime());
            orderVerifyInfo.setRemark(listChngOrder.get(0).getRemark());
        } else {
            orderVerifyInfo.setAdjustName(saleOrderMainInfo.getAdjustPriceOperName());
            orderVerifyInfo.setAdjustTime(saleOrderMainInfo.getAdjustPriceTime());
        }
        rspBo.setOrderVerifyInfo(orderVerifyInfo);
        UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
        relaQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        relaQryBo.setContactId(orderInfo.getContactId());
        relaQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        rspBo.setReceiverAddressBo(UocRu.js(uocOrdLogisticsRela, UocGetSaleOrderDetailServiceRspReceiverAddressBo.class));
        UocOrdInvoiceQryBo invoiceQryBo = new UocOrdInvoiceQryBo();
        invoiceQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        invoiceQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        UocOrdInvoice uocOrdInvoice = this.iUocOrderModel.qryOrderInvoice(invoiceQryBo);
        rspBo.setInvoiceBo(UocRu.js(uocOrdInvoice, UocGetSaleOrderDetailServiceRspInvoiceBo.class));
        log.info("\u8bbe\u7f6e\u53d1\u7968\u4fe1\u606f");
        UocGetSaleOrderDetailServiceRspReceiverAddressBo invoiceAddressBo = new UocGetSaleOrderDetailServiceRspReceiverAddressBo();
        if (ObjectUtil.isNotEmpty((Object)uocOrdInvoice) && uocOrdInvoice.getContactId() != null) {
            relaQryBo = new UocOrdLogisticsRelaQryBo();
            relaQryBo.setContactId(uocOrdInvoice.getContactId());
            relaQryBo.setOrderId(uocOrdInvoice.getOrderId());
            relaQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
            invoiceAddressBo = UocRu.js(this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo), UocGetSaleOrderDetailServiceRspReceiverAddressBo.class);
        }
        rspBo.setInvoiceAddressBo(invoiceAddressBo);
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
        uocOrderAccessoryQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        uocOrderAccessoryQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocOrderAccessory> saleOrderAccessoryList = this.iUocSaleOrderModel.getSaleOrderAccessoryList(uocOrderAccessoryQryBo).getSaleOrderAccessoryList();
        if (ObjectUtil.isNotEmpty(saleOrderAccessoryList)) {
            List<UocBaseOrderAccessoryDetailBo> accessoryDetailBos = UocRu.jsl(saleOrderAccessoryList, UocBaseOrderAccessoryDetailBo.class);
            Map<Integer, List<UocBaseOrderAccessoryDetailBo>> accessoryDetailMap = accessoryDetailBos.stream().collect(Collectors.groupingBy(UocBaseOrderAccessoryDetailBo::getAttachmentType));
            Iterator<Integer> iterator = accessoryDetailMap.keySet().iterator();
            while (iterator.hasNext()) {
                UocBaseOrderAccessoryTypeDetailBo accessoryTypeDetailBo = new UocBaseOrderAccessoryTypeDetailBo();
                Integer attachmentType = iterator.next();
                accessoryTypeDetailBo.setAttachmentType(attachmentType);
                accessoryTypeDetailBo.setAttchList(accessoryDetailMap.get(attachmentType));
                accessoryDetailBoList.add(accessoryTypeDetailBo);
            }
        }
        List<Object> uocBaseExtParallelBoList = new ArrayList();
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = UocRu.js(reqBo, UocSaleOrderMapQryBo.class);
        uocSaleOrderMapQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocSaleOrderMap> saleOrderExpandList = this.iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderExpandList)) {
            uocBaseExtParallelBoList = UocRu.jsl(saleOrderExpandList, UocBaseExtParallelBo.class);
        }
        rspBo.setSaleOrderDetailServiceRspExtBoList(uocBaseExtParallelBoList);
        rspBo.setExtFields(JSONArray.parseArray((String)JSON.toJSONString(uocBaseExtParallelBoList), BaseExtendFieldBo.class));
        Map<String, List<UocSaleOrderMap>> collectMap = saleOrderExpandList.stream().collect(Collectors.groupingBy(UocSaleOrderMap::getFieldCode));
        rspBo.setBudgetModelCode(CollUtil.isNotEmpty((Collection)collectMap.get("budgetModelCode")) ? collectMap.get("budgetModelCode").get(0).getFieldValue() : null);
        rspBo.setBudgetModelName(CollUtil.isNotEmpty((Collection)collectMap.get("budgetModelName")) ? collectMap.get("budgetModelName").get(0).getFieldValue() : null);
        rspBo.setFinancialId(CollUtil.isNotEmpty((Collection)collectMap.get("financialId")) ? collectMap.get("financialId").get(0).getFieldValue() : null);
        rspBo.setFinancialName(CollUtil.isNotEmpty((Collection)collectMap.get("financialName")) ? collectMap.get("financialName").get(0).getFieldValue() : null);
        rspBo.setCostCenterId(CollUtil.isNotEmpty((Collection)collectMap.get("costCenterId")) ? collectMap.get("costCenterId").get(0).getFieldValue() : null);
        rspBo.setCostCenterName(CollUtil.isNotEmpty((Collection)collectMap.get("costCenterName")) ? collectMap.get("costCenterName").get(0).getFieldValue() : null);
        rspBo.setRelevantDeptName(CollUtil.isNotEmpty((Collection)collectMap.get("relevantDeptName")) ? collectMap.get("relevantDeptName").get(0).getFieldValue() : null);
        rspBo.setBudgetProjectId(CollUtil.isNotEmpty((Collection)collectMap.get("budgetProjectId")) ? collectMap.get("budgetProjectId").get(0).getFieldValue() : null);
        rspBo.setBudgetProjectName(CollUtil.isNotEmpty((Collection)collectMap.get("budgetProjectName")) ? collectMap.get("budgetProjectName").get(0).getFieldValue() : null);
        rspBo.setUnifiedPurOrderFlag(CollUtil.isNotEmpty((Collection)collectMap.get("unifiedPurOrderFlag")) ? collectMap.get("unifiedPurOrderFlag").get(0).getFieldValue() : null);
        rspBo.setIncomeAndExpProjectId(CollUtil.isNotEmpty((Collection)collectMap.get("incomeAndExpProjectId")) ? collectMap.get("incomeAndExpProjectId").get(0).getFieldValue() : null);
        rspBo.setIncomeAndExpProjectName(CollUtil.isNotEmpty((Collection)collectMap.get("incomeAndExpProjectName")) ? collectMap.get("incomeAndExpProjectName").get(0).getFieldValue() : null);
        rspBo.setServiceFailTime(CollUtil.isNotEmpty((Collection)collectMap.get("serviceFailTime")) ? collectMap.get("serviceFailTime").get(0).getFieldValue() : null);
        rspBo.setServiceEffectiveTime(CollUtil.isNotEmpty((Collection)collectMap.get("serviceEffectiveTime")) ? collectMap.get("serviceEffectiveTime").get(0).getFieldValue() : null);
        HashMap<Long, UocShipOrderItem> shipOrderItemMap = new HashMap<Long, UocShipOrderItem>();
        ArrayList<UocShipOrderItem> allShipOrderItem = new ArrayList<UocShipOrderItem>();
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocShipOrderDo> shipOrderList = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        if (ObjectUtil.isNotEmpty(shipOrderList)) {
            for (UocShipOrderDo uocShipOrderDo : shipOrderList) {
                UocGetSaleOrderDetailServiceRspShipOrderInfoBo uocGetSaleOrderDetailServiceRspShipOrderInfoBo = UocRu.js(uocShipOrderDo, UocGetSaleOrderDetailServiceRspShipOrderInfoBo.class);
                UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
                uocShipOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
                uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
                uocShipOrderItemQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                UocShipOrderDo listShipOrderItem = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
                if (ObjectUtil.isNotEmpty(listShipOrderItem.getShipOrderItemBoList())) {
                    uocGetSaleOrderDetailServiceRspShipOrderInfoBo.setShipOrderItemInfo(UocRu.jsl(listShipOrderItem.getShipOrderItemBoList(), UocGetSaleOrderDetailServiceRspShipOrderItemBo.class));
                    allShipOrderItem.addAll(listShipOrderItem.getShipOrderItemBoList());
                }
                shipOrderInfo.add(uocGetSaleOrderDetailServiceRspShipOrderInfoBo);
            }
        }
        if (!CollectionUtils.isEmpty(allShipOrderItem)) {
            Map<Long, List<UocShipOrderItem>> shipOrderItemMapGroupBySkuItem = allShipOrderItem.stream().collect(Collectors.groupingBy(UocShipOrderItem::getSaleOrderItemId));
            for (Map.Entry<Long, List<UocShipOrderItem>> entry : shipOrderItemMapGroupBySkuItem.entrySet()) {
                BigDecimal sendCount = entry.getValue().stream().map(UocShipOrderItem::getSendCount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal inspCount = entry.getValue().stream().map(UocShipOrderItem::getInspCount).reduce(BigDecimal.ZERO, BigDecimal::add);
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setSendCount(sendCount);
                uocShipOrderItem.setInspCount(inspCount);
                shipOrderItemMap.put(entry.getKey(), uocShipOrderItem);
            }
            log.debug("shipOrderItemMapGroupBySkuItem\u660e\u7ec6:" + JSON.toJSONString(shipOrderItemMapGroupBySkuItem));
            log.debug("shipOrderItemMap\u660e\u7ec6:" + JSON.toJSONString(shipOrderItemMap));
        }
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(saleOrderMainInfo.getOrderId());
        uocInspOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocInspOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocInspOrderDo> list = this.iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
        if (ObjectUtil.isNotEmpty(list)) {
            for (UocInspOrderDo each3 : list) {
                UocGetSaleOrderDetailServiceRspInspOrderInfoBo inspOrderInfoBo = UocRu.js(each3, UocGetSaleOrderDetailServiceRspInspOrderInfoBo.class);
                UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
                uocInspOrderItemQryBo.setOrderId(each3.getOrderId());
                uocInspOrderItemQryBo.setInspOrderId(each3.getInspOrderId());
                uocInspOrderItemQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                UocInspOrderDo listInspOrderItem = this.iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
                if (null != listInspOrderItem && ObjectUtil.isNotEmpty(listInspOrderItem.getUocInspOrderItemList())) {
                    inspOrderInfoBo.setInspOrderItemInfo(UocRu.jsl(listInspOrderItem.getUocInspOrderItemList(), UocGetSaleOrderDetailServiceRspInspOrderItemInfoBo.class));
                }
                inspOrderInfo.add(inspOrderInfoBo);
            }
        }
        UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
        uocOrderShouldPay.setOrderId(saleOrderMainInfo.getOrderId());
        if (saleOrderMainInfo.getStakeholder() != null && StringUtils.isNotEmpty((CharSequence)saleOrderMainInfo.getStakeholder().getPurCompanyId())) {
            uocOrderShouldPay.setPayerId(Long.valueOf(saleOrderMainInfo.getStakeholder().getPurCompanyId()));
        }
        if (saleOrderMainInfo.getModelSettle().equals(UocConstant.ModelSettle.MY) && "2".equals(reqBo.getIsProfessionalOrgExt())) {
            uocOrderShouldPay.setPayerId(Long.valueOf(saleOrderMainInfo.getStakeholder().getProId()));
        }
        uocOrderShouldPay.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocOrderShouldPay> listPayOrder = this.iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
        if (ObjectUtil.isNotEmpty(listPayOrder)) {
            List<UocGetSaleOrderDetailServiceRspShouldPayOrderBo> shouldPayOrderBoList = UocRu.jsl(listPayOrder, UocGetSaleOrderDetailServiceRspShouldPayOrderBo.class);
            rspBo.setPayOrderInfo(shouldPayOrderBoList);
        }
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = UocRu.js(reqBo, UocSaleOrderItemQryBo.class);
        uocSaleOrderItemQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            Map<String, List<UocSaleOrderItem>> saleItemCommodityTypeMap = saleOrderItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getCommodityTypeId));
            ArrayList commodityTypeInspSuperCountList = new ArrayList();
            saleItemCommodityTypeMap.forEach((k, v) -> {
                BigDecimal purchaseCount = new BigDecimal(0);
                AtomicReference<Integer> inspectionExcessPercent = new AtomicReference<Integer>();
                BigDecimal inspSuperCount = new BigDecimal(0);
                for (UocSaleOrderItem m : v) {
                    purchaseCount = purchaseCount.add(m.getPurchaseCount());
                    inspectionExcessPercent.set(m.getInspectionExcessPercent() == null ? 0 : m.getInspectionExcessPercent());
                    inspSuperCount = inspSuperCount.add(m.getInspSuperCount() == null ? new BigDecimal(0) : m.getInspSuperCount());
                }
                BigDecimal remainInspSuperCount = purchaseCount.multiply(new BigDecimal((Integer)inspectionExcessPercent.get())).divide(BigDecimal.valueOf(100L)).subtract(inspSuperCount);
                if (remainInspSuperCount.compareTo(new BigDecimal(0)) < 0) {
                    remainInspSuperCount = new BigDecimal(0);
                }
                UocGetSaleOrderDetailServiceRspItemBo uocSaleOrderItem = new UocGetSaleOrderDetailServiceRspItemBo();
                uocSaleOrderItem.setCommodityTypeId(k);
                uocSaleOrderItem.setInspSuperCount(remainInspSuperCount);
                commodityTypeInspSuperCountList.add(uocSaleOrderItem);
            });
            rspBo.setCommodityTypeInspSuperCountList(commodityTypeInspSuperCountList);
            for (UocSaleOrderItem item : saleOrderItemList) {
                UocGetSaleOrderDetailServiceRspItemBo rspItemBo = UocRu.js((Object)item, UocGetSaleOrderDetailServiceRspItemBo.class);
                if (ObjectUtil.isNotEmpty(shipOrderItemMap) && shipOrderItemMap.containsKey(item.getSaleOrderItemId())) {
                    rspItemBo.setSendCount(((UocShipOrderItem)shipOrderItemMap.get(item.getSaleOrderItemId())).getSendCount());
                }
                if (ObjectUtil.isNotEmpty(shipOrderItemMap) && shipOrderItemMap.containsKey(item.getSaleOrderItemId())) {
                    rspItemBo.setAcceptanceCount(((UocShipOrderItem)shipOrderItemMap.get(item.getSaleOrderItemId())).getInspCount());
                }
                if (null == rspItemBo.getPurchaseFee() && null != rspItemBo.getPurchasePrice() && null != rspItemBo.getPurchaseCount()) {
                    rspItemBo.setPurchaseFee(rspItemBo.getPurchasePrice().multiply(rspItemBo.getPurchaseCount()));
                }
                if (null == rspItemBo.getSaleFee()) {
                    if (null == rspItemBo.getSalePrice()) {
                        rspItemBo.setSalePrice(rspItemBo.getPurchasePrice());
                    }
                    if (null != rspItemBo.getSalePrice() && null != rspItemBo.getPurchaseCount()) {
                        rspItemBo.setSaleFee(rspItemBo.getSalePrice().multiply(rspItemBo.getPurchaseCount()));
                    }
                }
                if (null == rspItemBo.getMarkUpRate()) {
                    rspItemBo.setMarkUpRate(Double.valueOf(BigDecimal.ZERO.doubleValue()));
                }
                rspItemBo.setSalePriceRear(rspItemBo.getSalePrice());
                rspItemBo.setPurchasePriceRear(rspItemBo.getPurchasePrice());
                if (null != rspItemBo.getSalePriceRear() && null != rspItemBo.getPurchasePriceRear()) {
                    rspItemBo.setMarkUpRateRear(Double.valueOf(rspItemBo.getSalePriceRear().subtract(rspItemBo.getPurchasePriceRear()).abs().divide(rspItemBo.getPurchasePriceRear(), 2).doubleValue()));
                }
                rspItemBo.setDistirbutionId(saleOrderMainInfo.getStakeholder().getProId());
                rspItemBo.setDistirbutionName(saleOrderMainInfo.getStakeholder().getProName());
                UocSaleItemMapQryBo uocSaleItemMapQryBo = new UocSaleItemMapQryBo();
                uocSaleItemMapQryBo.setSaleOrderItemId(item.getSaleOrderItemId());
                uocSaleItemMapQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                List<UocSaleItemMap> saleOrderItemMapList = this.iUocSaleOrderModel.getSaleOrderItemMapList(uocSaleItemMapQryBo);
                if (ObjectUtil.isNotEmpty(saleOrderItemMapList)) {
                    List<UocBaseExtParallelBo> uocBaseExtParallelBos = UocRu.jsl(saleOrderItemMapList, UocBaseExtParallelBo.class);
                    rspItemBo.setItemExtParallelBos(uocBaseExtParallelBos);
                    if (ObjectUtil.equal((Object)rspItemBo.getItemType(), (Object)UocDicConstant.ITEM_TYPE.COMMODITY_SKU)) {
                        rspItemBo.setCommExtParallelBos(uocBaseExtParallelBos);
                    }
                    rspItemBo.setDeliveryTimeDate(this.deliveryCycle(rspItemBo, saleOrderMainInfo, uocBaseExtParallelBos));
                    Map<String, List<UocBaseExtParallelBo>> itemExtMap = uocBaseExtParallelBos.stream().collect(Collectors.groupingBy(UocBaseExtParallelBo::getFieldCode));
                    rspItemBo.setPurchasePurposeName(CollUtil.isNotEmpty((Collection)itemExtMap.get("purchasePurposeName")) ? itemExtMap.get("purchasePurposeName").get(0).getFieldValue() : null);
                    rspItemBo.setPurchasePurposeId(CollUtil.isNotEmpty((Collection)itemExtMap.get("purchasePurposeId")) ? itemExtMap.get("purchasePurposeId").get(0).getFieldValue() : null);
                    rspItemBo.setCmoomdityClass(CollUtil.isNotEmpty((Collection)itemExtMap.get("cmoomdityClass")) ? itemExtMap.get("cmoomdityClass").get(0).getFieldValue() : null);
                }
                uocGetSaleOrderDetailServiceRspItemBos.add(rspItemBo);
                log.info("rspItemBo:" + JSON.toJSONString((Object)rspItemBo));
            }
        }
        if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrderMainInfo.getOrderSource())) {
            UocOrderQueryIndexQryBo queryIndexQryBo = new UocOrderQueryIndexQryBo();
            queryIndexQryBo.setOrderId(saleOrderMainInfo.getOrderId());
            queryIndexQryBo.setObjId(reqBo.getSaleOrderId());
            queryIndexQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            queryIndexQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
            List<UocOrderQueryIndex> uocOrderQueryIndices = this.iUocOrderModel.qryOrderQueryIndexList(queryIndexQryBo);
            if (ObjectUtil.isNotEmpty(uocOrderQueryIndices)) {
                rspBo.setOutOrderId(uocOrderQueryIndices.get(0).getOutObjId());
            }
        }
        List<UocAuditOrderDo> auditOrderList = this.getAuditOrderList(saleOrderMainInfo.getOrderId(), reqBo.getSaleOrderId(), UocDicConstant.OBJ_TYPE.SALE, dataAchiveTabSuffix);
        rspBo.setAuditOrderBoList(UocRu.jsl(auditOrderList, UocSaleOrderAuditBO.class));
        List<UocAuditOrderDo> wholeAuditOrderList = this.getAuditOrderList(saleOrderMainInfo.getOrderId(), saleOrderMainInfo.getOrderId(), UocDicConstant.OBJ_TYPE.ORDER, dataAchiveTabSuffix);
        rspBo.setWholeAuditOrderBoList(UocRu.jsl(wholeAuditOrderList, UocSaleOrderAuditBO.class));
        List<UocAuditOrderDo> approvalPlusAuditOrderList = this.getAuditOrderList(saleOrderMainInfo.getOrderId(), saleOrderMainInfo.getSaleOrderId(), UocDicConstant.OBJ_TYPE.SALE, dataAchiveTabSuffix);
        rspBo.setApprovalPlusAuditOrderList(UocRu.jsl(approvalPlusAuditOrderList, UocSaleOrderAuditBO.class));
        if (ObjectUtil.isNotEmpty(accessoryDetailBoList)) {
            ConcurrentMap<Integer, List<UocBaseOrderAccessoryTypeDetailBo>> accessoryMap = accessoryDetailBoList.stream().collect(Collectors.groupingByConcurrent(UocBaseOrderAccessoryTypeDetailBo::getAttachmentType));
            if (!CollectionUtils.isEmpty((Collection)((Collection)accessoryMap.get(UocAttachementTypeConstants.CREATE_ORDER)))) {
                List uocBaseOrderAccessoryTypeDetailBos = (List)accessoryMap.get(UocAttachementTypeConstants.CREATE_ORDER);
                for (UocBaseOrderAccessoryTypeDetailBo uocBaseOrderAccessoryTypeDetailBo : uocBaseOrderAccessoryTypeDetailBos) {
                    List attchList = uocBaseOrderAccessoryTypeDetailBo.getAttchList().stream().filter(v -> v.getObjType() == 1).collect(Collectors.toList());
                    uocBaseOrderAccessoryTypeDetailBo.setAttchList(attchList);
                }
            }
            rspBo.setOrderAccessoryList(accessoryDetailBoList);
            rspBo.setRejectAccessoryList((List)accessoryMap.get(UocAttachementTypeConstants.SALE_ORDER_REJECT));
            rspBo.setCancelAccessoryList((List)accessoryMap.get(UocAttachementTypeConstants.CANCEL_SALE_ORDER));
            rspBo.setCancelApplyAccessoryList((List)accessoryMap.get(UocAttachementTypeConstants.CANCEL_APPLY_SALE_ORDER));
            rspBo.setArriveRegistAccessoryList((List)accessoryMap.get(UocAttachementTypeConstants.ARRIVAL_REGIST));
        }
        rspBo.setSaleOrderDetailServiceRspItemBoList(uocGetSaleOrderDetailServiceRspItemBos);
        rspBo.setShipOrderInfo(shipOrderInfo);
        rspBo.setInspOrderInfo(inspOrderInfo);
        this.translateProperties(rspBo);
        this.judgeSupplierConfirm(rspBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UocGetSaleOrderDetailServiceRspAgreementInfoBo queryOrderAgrInfo(Long order, Long agrDataId, String dataAchiveTabSuffix) {
        UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
        uocOrderAgreementQryBo.setOrderId(order);
        uocOrderAgreementQryBo.setId(agrDataId);
        uocOrderAgreementQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocOrderAgreement> agreementOrderList = this.iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
        if (!CollectionUtils.isEmpty(agreementOrderList)) {
            UocGetSaleOrderDetailServiceRspAgreementInfoBo agreementInfoBo = new UocGetSaleOrderDetailServiceRspAgreementInfoBo();
            BeanUtils.copyProperties((Object)((Object)agreementOrderList.get(0)), (Object)agreementInfoBo);
            return agreementInfoBo;
        }
        throw new BaseBusinessException("100001", "\u67e5\u8be2\u8ba2\u5355\u534f\u8bae\u4fe1\u606f\u5931\u8d25");
    }

    private UocOrderDo queryOrderInfo(Long orderId, String dataAchiveTabSuffix) {
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(orderId);
        uocOrderDo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        UocOrderDo orderInfo = this.iUocOrderModel.qryOrderBy(uocOrderDo);
        if (null != orderInfo) {
            return orderInfo;
        }
        throw new BaseBusinessException("100001", "\u67e5\u8be2\u4e3b\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
    }

    private UocSaleOrderDo querySaleOrderMainInfo(UocGetSaleOrderDetailServiceReqBo reqBo, String dataAchiveTabSuffix) {
        UocSaleOrderQryBo uocSaleOrderQryBo = UocRu.js(reqBo, UocSaleOrderQryBo.class);
        uocSaleOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        UocSaleOrderDo saleOrderMainInfo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        return saleOrderMainInfo;
    }

    private void judgeSupplierConfirm(UocGetSaleOrderDetailServiceRspBo rspBo) {
        String saleOrderStateStr = rspBo.getSaleOrderStateStr();
        Boolean isSupConfirm = false;
        if (ObjectUtil.notEqual((Object)saleOrderStateStr, (Object)"\u5206\u914d\u4e2d") && ObjectUtil.notEqual((Object)saleOrderStateStr, (Object)"\u6838\u5b9e\u4e2d") && ObjectUtil.notEqual((Object)saleOrderStateStr, (Object)"\u590d\u6838\u4e2d") && ObjectUtil.notEqual((Object)saleOrderStateStr, (Object)"\u5f85\u786e\u8ba4")) {
            isSupConfirm = true;
        }
        rspBo.setIsSupplierConfirmFlag(isSupConfirm);
        rspBo.setIsShipFlag(Boolean.valueOf(false));
        if (!CollectionUtils.isEmpty((Collection)rspBo.getShipOrderInfo())) {
            rspBo.setIsShipFlag(Boolean.valueOf(true));
        }
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(UocSaleOrderDo uocSaleOrderDo, String isSale, String dataAchiveTabSuffix) {
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        Boolean isSaleFlag = false;
        if (StringUtils.isNotBlank((CharSequence)isSale) && isSale.equals("1")) {
            procInstQryBo.setObjId(uocSaleOrderDo.getSaleOrderId());
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            isSaleFlag = true;
        }
        procInstQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        procInstQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            List<UocGetSaleOrderDetailServiceRspPorcBo> procBoList = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class);
            Map<Integer, List<UocGetSaleOrderDetailServiceRspPorcBo>> procBosMap = procBoList.stream().collect(Collectors.groupingBy(UocGetSaleOrderDetailServiceRspPorcBo::getObjType));
            if (ObjectUtil.isNotEmpty(procBosMap.get(UocDicConstant.OBJ_TYPE.SALE))) {
                procInst = procBosMap.get(UocDicConstant.OBJ_TYPE.SALE).get(0);
            }
            ArrayList<UocOrderTaskInst> uocOrderTaskInsts = new ArrayList<UocOrderTaskInst>();
            if (isSaleFlag.booleanValue()) {
                uocOrderTaskInsts.addAll(this.getOrderTaskInsts(procInst, dataAchiveTabSuffix));
            } else {
                procBoList.forEach(bo -> uocOrderTaskInsts.addAll(this.getOrderTaskInsts((UocGetSaleOrderDetailServiceRspPorcBo)bo, dataAchiveTabSuffix)));
            }
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                Map<Integer, List<UocGetSaleOrderDetailServiceRspTaskBo>> taskBosMap = taskBoList.stream().collect(Collectors.groupingBy(UocGetSaleOrderDetailServiceRspTaskBo::getObjType));
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    taskDealQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                });
                if (ObjectUtil.isNotEmpty(taskBosMap.get(UocDicConstant.OBJ_TYPE.SALE))) {
                    procInst.setProcState(taskBosMap.get(UocDicConstant.OBJ_TYPE.SALE).get(0).getProcState());
                    procInst.setTaskId(taskBosMap.get(UocDicConstant.OBJ_TYPE.SALE).get(0).getTaskInstId());
                }
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }

    private List<UocGetSaleOrderDetailServiceRspPorcBo> getProcTacheFinish(UocSaleOrderDo uocSaleOrderDo, String dataAchiveTabSuffix) {
        ArrayList<UocGetSaleOrderDetailServiceRspPorcBo> proInstFinishList = new ArrayList<UocGetSaleOrderDetailServiceRspPorcBo>();
        List<UocOrderTaskInst> orderTaskInstsAll = this.getOrderTaskInstsAll(uocSaleOrderDo, dataAchiveTabSuffix);
        if (!CollectionUtils.isEmpty(orderTaskInstsAll)) {
            orderTaskInstsAll.forEach(v -> {
                UocGetSaleOrderDetailServiceRspPorcBo bo = new UocGetSaleOrderDetailServiceRspPorcBo();
                BeanUtils.copyProperties((Object)v, (Object)bo);
                bo.setFinishTag(v.getFinishTag());
                bo.setProcState(v.getProcState());
                bo.setFinishTime(v.getFinishTime());
                proInstFinishList.add(bo);
            });
        }
        return proInstFinishList;
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getAuditProcInst(UocSaleOrderDo uocSaleOrderDo, Integer objType, String dataAchiveTabSuffix) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        if (UocDicConstant.OBJ_TYPE.SALE.equals(objType)) {
            uocApprovalObjQryBo.setObjId(uocSaleOrderDo.getSaleOrderId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        } else {
            uocApprovalObjQryBo.setObjId(uocSaleOrderDo.getOrderId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        }
        uocApprovalObjQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (ObjectUtil.isNotEmpty(uocApprovalObjs)) {
            List<Long> auditOrderIds = uocApprovalObjs.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList());
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setOrderId(uocSaleOrderDo.getOrderId());
            taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskInstQryBo.setObjIdList(auditOrderIds);
            taskInstQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                String procInstId;
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocApprovalObjQryBo uocApprovalObjQryBo1 = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo1.setAuditOrderId(each.getObjId());
                    uocApprovalObjQryBo1.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                    List<UocApprovalObj> uocApprovalObjs1 = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo1);
                    Integer objBusiType = uocApprovalObjs1.get(0).getObjBusiType();
                    each.setObjBusiType(objBusiType);
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    if (ObjectUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDeal = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDeal.getDealId();
                        String dealName = uocOrderTaskDeal.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    String auditDealResultQryKey = each.getDealId() + LINE + each.getObjBusiType();
                    if (each.getDealResult() != null) {
                        auditDealResultQryKey = auditDealResultQryKey + LINE + each.getDealResult();
                    }
                    each.setAuditDealResultQryKey(auditDealResultQryKey);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                });
                procInst.setTaskList(taskBoList);
                String string = procInstId = CollectionUtils.isEmpty(uocOrderTaskInsts) ? "" : uocOrderTaskInsts.get(0).getProcInstId();
                if (StringUtils.isNotBlank((CharSequence)procInstId)) {
                    procInst.setProcInstId(procInstId);
                }
            }
        }
        return procInst;
    }

    private List<UocOrderTaskInst> getOrderTaskInsts(UocGetSaleOrderDetailServiceRspPorcBo procInst, String dataAchiveTabSuffix) {
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setObjId(procInst.getObjId());
        taskInstQryBo.setObjType(procInst.getObjType());
        taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        taskInstQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        return uocOrderTaskInsts;
    }

    private List<UocOrderTaskInst> getOrderTaskInstsAll(UocSaleOrderDo uocSaleOrderDo, String dataAchiveTabSuffix) {
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        taskInstQryBo.setObjId(uocSaleOrderDo.getSaleOrderId());
        taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
        taskInstQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        return uocOrderTaskInsts;
    }

    private List<UocAuditOrderDo> getAuditOrderList(Long orderId, Long objId, Integer objType, String dataAchiveTabSuffix) {
        UocApprovalObjQryBo obj = new UocApprovalObjQryBo();
        obj.setOrderId(orderId);
        obj.setObjId(Convert.toStr((Object)objId));
        obj.setObjType(objType);
        obj.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(obj);
        log.info("\u67e5\u8be2uocApprovalObjs\uff1a{}", (Object)JSON.toJSONString(uocApprovalObjs));
        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
            return new ArrayList<UocAuditOrderDo>();
        }
        ArrayList<Long> auditOrderIdList = new ArrayList<Long>();
        uocApprovalObjs.forEach(uocApprovalObj -> auditOrderIdList.add(uocApprovalObj.getAuditOrderId()));
        List<UocAuditOrderDo> uocAuditOrderDoList = new ArrayList<UocAuditOrderDo>();
        UocAuditOrderQryBo auditOrderQryBo = new UocAuditOrderQryBo();
        auditOrderQryBo.setOrderId(orderId);
        auditOrderQryBo.setAuditOrderIdList(auditOrderIdList);
        auditOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocAuditOrder> uocAuditOrders = this.iUocAuditOrderModel.qryAuditOrderList(auditOrderQryBo);
        log.info("\u67e5\u8be2uocAuditOrders\uff1a{}", (Object)JSON.toJSONString(uocAuditOrders));
        if (ObjectUtil.isNotEmpty(uocAuditOrders)) {
            uocAuditOrders.forEach(uocAuditOrder -> {
                UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
                procInstQryBo.setObjId(uocAuditOrder.getAuditOrderId());
                procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
                procInstQryBo.setOrderId(orderId);
                procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                procInstQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
                List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
                log.info("\u67e5\u8be2uocOrderProcInsts\uff1a{}", (Object)JSON.toJSONString(uocOrderProcInsts));
                if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
                    uocAuditOrder.setProcInstId(uocOrderProcInsts.get(0).getProcInstId());
                }
            });
            uocAuditOrderDoList = UocRu.jsl(uocAuditOrders, UocAuditOrderDo.class);
            Map approvalObjMap = uocApprovalObjs.stream().collect(Collectors.groupingByConcurrent(UocApprovalObj::getAuditOrderId));
            uocAuditOrderDoList.forEach(each -> each.setApprovalObjs((List)approvalObjMap.get(each.getAuditOrderId())));
        }
        return uocAuditOrderDoList;
    }

    private static void initialize() {
        pCodeList.add("UOC_SALE_ORDER_STATE");
        pCodeList.add("UOC_SALE_ORDER_NOARGEE_TACHE_CODE");
        pCodeList.add("UOC_SALE_ORDER_ARGEE_TACHE_CODE");
        pCodeList.add("UOC_SALE_ORDER_ECOM_TACHE_CODE");
        pCodeList.add("UOC_SALE_ORDER_SOURCE");
        pCodeList.add("UOC_SALE_ORDER_PAY_TYPE");
        pCodeList.add("UOC_SALE_ORDER_PAY_STATE");
        pCodeList.add("UOC_COMMON_FINISH_FLAG");
        pCodeList.add("UOC_COMMON_MODEL_SETTLE");
        pCodeList.add("UOC_COMMON_PURCHASE_TYPE");
        pCodeList.add("UOC_COMMON_PURCHASE_MODE");
        pCodeList.add("UOC_ORD_INVOICE_TYPE");
        pCodeList.add("UOC_ORD_INVOICE_CATEGORY");
        pCodeList.add("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE");
        pCodeList.add("UOC_ORDER_OBJ_TYPE");
        pCodeList.add("UOC_COMMON_ITEM_TYPE");
        pCodeList.add("UOC_ORDER_TASK_DEAL_TYPE");
        pCodeList.add("UOC_ORDER_TASK_DEAL_CLASS");
        pCodeList.add("UOC_ORD_AGREEMENT_MODE");
        pCodeList.add("UOC_ORD_ADJUST_PRICE");
        pCodeList.add("SHIP_ORDER_STATE");
        pCodeList.add("INSP_ORDER_STATE");
        pCodeList.add("SHOULD_PAY_TYPE");
        pCodeList.add("UOC_SALE_ORDER_ALL_TACHE_CODE_MAIN");
    }

    private void translateProperties(UocGetSaleOrderDetailServiceRspBo rspBo) {
        Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        if (ObjectUtil.isNotEmpty(dictionaryMap)) {
            Integer orderSource = rspBo.getOrderSource();
            String saleOrderState = rspBo.getSaleOrderState();
            UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = rspBo.getProcInst();
            ArrayList<String> stateList = new ArrayList<String>();
            stateList.add(saleOrderState);
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_NOARGEE_TACHE_CODE")) && UocConstant.SkuSource.SELF.equals(orderSource) && ObjectUtil.isNotEmpty(stateList)) {
                rspBo.setSaleOrderStateStr(dictionaryMap.get("UOC_SALE_ORDER_NOARGEE_TACHE_CODE").get(stateList.get(0)));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_ECOM_TACHE_CODE")) && UocConstant.SkuSource.ELC.equals(orderSource) && ObjectUtil.isNotEmpty(stateList)) {
                rspBo.setSaleOrderStateStr(dictionaryMap.get("UOC_SALE_ORDER_ECOM_TACHE_CODE").get(stateList.get(0)));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_ARGEE_TACHE_CODE")) && UocConstant.SkuSource.AGR.equals(orderSource) && ObjectUtil.isNotEmpty(stateList)) {
                rspBo.setSaleOrderStateStr(dictionaryMap.get("UOC_SALE_ORDER_ARGEE_TACHE_CODE").get(stateList.get(0)));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_SOURCE")) && ObjectUtil.isNotEmpty((Object)rspBo.getOrderSource())) {
                rspBo.setOrderSourceStr(dictionaryMap.get("UOC_SALE_ORDER_SOURCE").get(rspBo.getOrderSource().toString()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_PAY_TYPE"))) {
                rspBo.setPayTypeStr(dictionaryMap.get("UOC_SALE_ORDER_PAY_TYPE").get(rspBo.getPayType()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_PAY_STATE")) && ObjectUtil.isNotEmpty((Object)rspBo.getPayState())) {
                rspBo.setPayStateStr(dictionaryMap.get("UOC_SALE_ORDER_PAY_STATE").get(rspBo.getPayState().toString()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_FINISH_FLAG")) && ObjectUtil.isNotEmpty((Object)rspBo.getFinishFlag())) {
                rspBo.setFinishFlagStr(dictionaryMap.get("UOC_COMMON_FINISH_FLAG").get(rspBo.getFinishFlag().toString()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_MODEL_SETTLE")) && ObjectUtil.isNotEmpty((Object)rspBo.getModelSettle())) {
                rspBo.setModelSettleStr(dictionaryMap.get("UOC_COMMON_MODEL_SETTLE").get(rspBo.getModelSettle().toString()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_PURCHASE_TYPE")) && ObjectUtil.isNotEmpty((Object)rspBo.getPurchaseType())) {
                rspBo.setPurchaseTypeStr(dictionaryMap.get("UOC_COMMON_PURCHASE_TYPE").get(rspBo.getPurchaseType().toString()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_PURCHASE_MODE")) && ObjectUtil.isNotEmpty((Object)rspBo.getPurchaseMode())) {
                rspBo.setPurchaseModeStr(dictionaryMap.get("UOC_COMMON_PURCHASE_MODE").get(rspBo.getPurchaseMode().toString()));
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getInvoiceBo())) {
                UocGetSaleOrderDetailServiceRspInvoiceBo invoiceBo = rspBo.getInvoiceBo();
                if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORD_INVOICE_TYPE")) && ObjectUtil.isNotEmpty((Object)invoiceBo.getInvoiceType())) {
                    invoiceBo.setInvoiceTypeStr(dictionaryMap.get("UOC_ORD_INVOICE_TYPE").get(invoiceBo.getInvoiceType().toString()));
                }
                if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORD_INVOICE_CATEGORY")) && ObjectUtil.isNotEmpty((Object)invoiceBo.getInvoceCategory())) {
                    invoiceBo.setInvoceCategoryStr(dictionaryMap.get("UOC_ORD_INVOICE_CATEGORY").get(invoiceBo.getInvoceCategory().toString()));
                }
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getOrderAccessoryList())) {
                this.translateAccessory(rspBo, UocAttachementTypeConstants.CREATE_ORDER, dictionaryMap);
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getRejectAccessoryList())) {
                this.translateAccessory(rspBo, UocAttachementTypeConstants.SALE_ORDER_REJECT, dictionaryMap);
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getCancelAccessoryList())) {
                this.translateAccessory(rspBo, UocAttachementTypeConstants.CANCEL_SALE_ORDER, dictionaryMap);
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getSaleOrderDetailServiceRspItemBoList())) {
                rspBo.getSaleOrderDetailServiceRspItemBoList().forEach(each -> {
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_ITEM_TYPE")) && ObjectUtil.isNotEmpty((Object)each.getItemType())) {
                        each.setItemTypeStr((String)((Map)dictionaryMap.get("UOC_COMMON_ITEM_TYPE")).get(each.getItemType().toString()));
                    }
                });
            }
            if (ObjectUtil.isNotNull((Object)rspBo.getAgreementInfo())) {
                UocGetSaleOrderDetailServiceRspAgreementInfoBo agreementInfo = rspBo.getAgreementInfo();
                if (null != agreementInfo.getAgreementCode()) {
                    agreementInfo.setAgreementCodeStr(dictionaryMap.get("UOC_ORD_AGREEMENT_MODE").get(agreementInfo.getAgreementCode().toString()));
                }
                if (null != agreementInfo.getAdjustPrice()) {
                    agreementInfo.setAdjustPriceStr(dictionaryMap.get("UOC_ORD_ADJUST_PRICE").get(agreementInfo.getAdjustPrice().toString()));
                }
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getProcInst())) {
                UocGetSaleOrderDetailServiceRspPorcBo procInst = rspBo.getProcInst();
                if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_OBJ_TYPE")) && ObjectUtil.isNotEmpty((Object)procInst.getObjType())) {
                    procInst.setObjTypeStr(dictionaryMap.get("UOC_ORDER_OBJ_TYPE").get(procInst.getObjType().toString()));
                }
                if (ObjectUtil.isNotEmpty((Object)procInst.getTaskList())) {
                    procInst.getTaskList().forEach(each -> {
                        if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_OBJ_TYPE")) && ObjectUtil.isNotEmpty((Object)each.getObjType())) {
                            each.setObjTypeStr((String)((Map)dictionaryMap.get("UOC_ORDER_OBJ_TYPE")).get(each.getObjType().toString()));
                        }
                        if (ObjectUtil.isNotEmpty((Object)each.getTaskDealBo())) {
                            for (UocGetSaleOrderDetailServiceRspTaskDealBo taskDealBo : each.getTaskDealBo()) {
                                if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_OBJ_TYPE")) && ObjectUtil.isNotEmpty((Object)taskDealBo.getObjType())) {
                                    taskDealBo.setObjTypeStr((String)((Map)dictionaryMap.get("UOC_ORDER_OBJ_TYPE")).get(taskDealBo.getObjType().toString()));
                                }
                                if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_TASK_DEAL_TYPE")) && ObjectUtil.isNotEmpty((Object)taskDealBo.getDealType())) {
                                    taskDealBo.setDealTypeStr((String)((Map)dictionaryMap.get("UOC_ORDER_TASK_DEAL_TYPE")).get(taskDealBo.getDealType().toString()));
                                }
                                if (!ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_TASK_DEAL_CLASS"))) continue;
                                taskDealBo.setDealClassStr((String)((Map)dictionaryMap.get("UOC_ORDER_TASK_DEAL_CLASS")).get(taskDealBo.getDealClass()));
                            }
                        }
                    });
                }
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getShipOrderInfo())) {
                rspBo.getShipOrderInfo().forEach(each -> {
                    each.setShipOrderStateStr((String)((Map)dictionaryMap.get("SHIP_ORDER_STATE")).get(each.getShipOrderState()));
                    if (ObjectUtil.isNotEmpty((Object)each.getShipOrderItemInfo())) {
                        each.getShipOrderItemInfo().forEach(item -> item.setShipItemStateStr((String)((Map)dictionaryMap.get("SHIP_ORDER_STATE")).get(item.getShipItemState())));
                    }
                });
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getInspOrderInfo())) {
                rspBo.getInspOrderInfo().forEach(each -> {
                    each.setInspOrderStateStr((String)((Map)dictionaryMap.get("INSP_ORDER_STATE")).get(each.getInspOrderState()));
                    if (ObjectUtil.isNotEmpty((Object)each.getInspOrderItemInfo())) {
                        each.getInspOrderItemInfo().forEach(item -> item.setInspItemStatusStr((String)((Map)dictionaryMap.get("SHIP_ORDER_STATE")).get(item.getInspItemStatus())));
                    }
                });
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getPayOrderInfo())) {
                rspBo.getPayOrderInfo().forEach(v -> {
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get("SHOULD_PAY_TYPE")) && ObjectUtil.isNotEmpty((Object)v.getShouldPayType())) {
                        v.setShouldPayTypeStr((String)((Map)dictionaryMap.get("SHOULD_PAY_TYPE")).get(String.valueOf(v.getShouldPayType())));
                    }
                    if (v.getIsPayCompleted().equals(1)) {
                        v.setIsPayCompletedStr("\u5df2\u4ed8\u6b3e");
                    } else {
                        v.setIsPayCompletedStr("\u5f85\u4ed8\u6b3e");
                    }
                });
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getFinishTacheInfo()) && ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_ALL_TACHE_CODE_MAIN"))) {
                List<UocGetSaleOrderDetailServiceRspPorcBo> collect = rspBo.getFinishTacheInfo().stream().filter(v -> ((Map)dictionaryMap.get("UOC_SALE_ORDER_ALL_TACHE_CODE_MAIN")).get(v.getProcState()) != null).collect(Collectors.toList());
                collect.forEach(value -> value.setProcStateStr((String)((Map)dictionaryMap.get("UOC_SALE_ORDER_ALL_TACHE_CODE_MAIN")).get(value.getProcState())));
                rspBo.setFinishTacheInfo(collect);
            }
        }
    }

    private void translateAccessory(UocGetSaleOrderDetailServiceRspBo rspBo, Integer accessoryType, Map<String, Map<String, String>> dictionaryMap) {
        List accessoryList = ObjectUtil.equal((Object)accessoryType, (Object)UocAttachementTypeConstants.SALE_ORDER_REJECT) ? rspBo.getRejectAccessoryList() : (ObjectUtil.equal((Object)accessoryType, (Object)UocAttachementTypeConstants.CANCEL_SALE_ORDER) ? rspBo.getCancelAccessoryList() : rspBo.getOrderAccessoryList());
        accessoryList.forEach(each -> {
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE")) && ObjectUtil.isNotEmpty((Object)each.getAttachmentType())) {
                each.setAttachmentTypeStr((String)((Map)dictionaryMap.get("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE")).get(each.getAttachmentType().toString()));
            }
            if (ObjectUtil.isNotEmpty((Object)each.getAttchList())) {
                for (UocBaseOrderAccessoryDetailBo accessoryDetailBo : each.getAttchList()) {
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_OBJ_TYPE")) && ObjectUtil.isNotEmpty((Object)accessoryDetailBo.getObjType())) {
                        accessoryDetailBo.setObjTypeStr((String)((Map)dictionaryMap.get("UOC_ORDER_OBJ_TYPE")).get(accessoryDetailBo.getObjType().toString()));
                    }
                    if (!ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE")) || !ObjectUtil.isNotEmpty((Object)accessoryDetailBo.getAttachmentType())) continue;
                    accessoryDetailBo.setAttachmentTypeStr((String)((Map)dictionaryMap.get("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE")).get(accessoryDetailBo.getAttachmentType().toString()));
                }
            }
        });
    }

    private String deliveryCycle(UocGetSaleOrderDetailServiceRspItemBo rspItemBo, UocSaleOrderDo uocSaleOrderDo, List<UocBaseExtParallelBo> uocBaseExtParallelBos) {
        Map<String, List<UocBaseExtParallelBo>> collect = uocBaseExtParallelBos.stream().collect(Collectors.groupingBy(UocBaseExtParallelBo::getFieldCode));
        List<UocBaseExtParallelBo> deliveryCycle = collect.get("delivery_cycle");
        String arriveTime = null;
        if (!CollectionUtils.isEmpty(deliveryCycle)) {
            arriveTime = deliveryCycle.get(0).getFieldValue();
            if (null != uocSaleOrderDo.getRejectTime() && null == uocSaleOrderDo.getRejectReason()) {
                long time = uocSaleOrderDo.getRejectTime().getTime() + Long.parseLong(arriveTime) * 24L * 60L * 60L * 1000L;
                Date date = new Date();
                date.setTime(time);
                arriveTime = new SimpleDateFormat("yyyy-MM-dd HH:ss:mm").format(date);
            }
        }
        return arriveTime;
    }

    private void validateParam(UocGetSaleOrderDetailServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getSaleOrderId() == null && reqBo.getSaleOrderNo() == null) {
            throw new BaseBusinessException("100001", "\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    static {
        UocGetSaleOrderDetailServiceImpl.initialize();
    }
}

