/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspEstimateSaleItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocReceiveItInspOrderNoItemReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocReceiveItInspOrderNoItemRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class UocArrvaITAcceptanceByNoItemTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocArrvaITAcceptanceByNoItemTransaction.class);
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    private static final String OP_FLAG_YES = "1";
    private static final String OP_FLAG_NO = "0";
    private static final String EC_IMPORT = "2";
    private static final String SUP_NO = "0";
    @Value(value="${uoc.createOrderSettleRelInfo:true}")
    private boolean createOrderSettleRelInfo;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocReceiveItInspOrderNoItemRspBo dealItArrvalAcceptance(UocReceiveItInspOrderNoItemReqBo reqBo) {
        this.verifyParam(reqBo);
        UocSaleOrderDo saleOrderMainInfo = this.querySaleOrderMainInfo(reqBo);
        List itemBoList = this.estimateSaleITemInspCount(reqBo, saleOrderMainInfo);
        reqBo.setSaleOrderItemList(itemBoList);
        this.updateSaleOrderInfo(reqBo, saleOrderMainInfo.getSaleOrderItems());
        Long inspOrderId = this.createInspOrder(reqBo, saleOrderMainInfo.getSaleOrderItems());
        this.createOrderSettleRelInfo(reqBo, inspOrderId);
        Boolean inspFinish = this.determineFinishAndUpdateSaleState(reqBo);
        UocReceiveItInspOrderNoItemRspBo rspBo = UocRu.success(UocReceiveItInspOrderNoItemRspBo.class);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setFinish(inspFinish);
        rspBo.setOpFlag(inspFinish != false ? OP_FLAG_YES : "0");
        rspBo.setInspOrderId(inspOrderId);
        return rspBo;
    }

    private List estimateSaleITemInspCount(UocReceiveItInspOrderNoItemReqBo reqBo, UocSaleOrderDo saleOrderMainInfo) {
        BigDecimal inspectionMoney = new BigDecimal(reqBo.getInspMoney());
        BigDecimal inspectionRate = inspectionMoney.divide(saleOrderMainInfo.getTotalSaleFee(), 8, RoundingMode.HALF_UP);
        log.info("\u672c\u6b21IT\u5de5\u4f5c\u53f0\u9a8c\u6536\u6bd4\u4f8b\uff1a" + inspectionRate);
        ArrayList<UocCreateInspEstimateSaleItemBo> itemBoList = new ArrayList<UocCreateInspEstimateSaleItemBo>();
        BigDecimal tmpTotal = new BigDecimal(0);
        List<UocSaleOrderItem> saleOrderItems = saleOrderMainInfo.getSaleOrderItems();
        for (int i = 0; i < saleOrderItems.size(); ++i) {
            UocSaleOrderItem saleOrderItem = saleOrderItems.get(i);
            UocCreateInspEstimateSaleItemBo estimateSaleItemBo = UocRu.js((Object)saleOrderItem, UocCreateInspEstimateSaleItemBo.class);
            if (i == saleOrderItems.size() - 1 && saleOrderItems.size() > 1) {
                BigDecimal lastItemSaleFee = saleOrderMainInfo.getTotalSaleFee().subtract(tmpTotal);
                estimateSaleItemBo.setInspCount(lastItemSaleFee.divide(saleOrderItem.getSalePrice()).setScale(2, RoundingMode.HALF_UP));
            } else {
                estimateSaleItemBo.setInspCount(saleOrderItem.getPurchaseCount().multiply(inspectionRate).setScale(2, RoundingMode.HALF_UP));
                tmpTotal = tmpTotal.add(saleOrderItem.getSaleFee().multiply(inspectionRate));
            }
            itemBoList.add(estimateSaleItemBo);
        }
        return itemBoList;
    }

    private Boolean determineFinishAndUpdateSaleState(UocReceiveItInspOrderNoItemReqBo reqBo) {
        if (reqBo.getInspFinish().booleanValue()) {
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
            uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            this.updateSaleOrderState(saleOrderItemList, reqBo);
            return true;
        }
        return false;
    }

    private Long createInspOrder(UocReceiveItInspOrderNoItemReqBo reqBo, List<UocSaleOrderItem> saleOrderItems) {
        Map<Long, UocSaleOrderItem> uocSaleOrderItemMap = saleOrderItems.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        UocInspOrderDo createInspOrderDo = new UocInspOrderDo();
        Long inspOrderId = IdUtil.nextId();
        createInspOrderDo.setOrderId(saleOrderItems.get(0).getOrderId());
        createInspOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        createInspOrderDo.setInspOrderId(inspOrderId);
        createInspOrderDo.setInspOrderNo(this.getInspOrderNo(reqBo));
        createInspOrderDo.setInspOrderState("YS_YS_YS");
        createInspOrderDo.setInspOper(reqBo.getInspOperId());
        createInspOrderDo.setCreateOperId(reqBo.getInspOperId());
        createInspOrderDo.setCreateTime(new Date());
        createInspOrderDo.setInvoiceTag(UocConstant.INVOICE_TAG.NO);
        ArrayList<UocShipInspRel> uocShipInspRelList = new ArrayList<UocShipInspRel>();
        ArrayList<UocInspOrderItem> uocInspOrderItemList = new ArrayList<UocInspOrderItem>();
        Map<Long, UocCreateInspEstimateSaleItemBo> inspItemBOMap = reqBo.getSaleOrderItemList().stream().collect(Collectors.toMap(UocCreateInspEstimateSaleItemBo::getSaleOrderItemId, e -> e));
        saleOrderItems.forEach(uocSaleOrderItem -> {
            UocInspOrderItem createInspOrderItem = new UocInspOrderItem();
            createInspOrderItem.setOrderId(uocSaleOrderItem.getOrderId());
            createInspOrderItem.setSaleOrderId(reqBo.getSaleOrderId());
            createInspOrderItem.setInspOrderId(createInspOrderDo.getInspOrderId());
            createInspOrderItem.setInspOrderItemId(IdUtil.nextId());
            createInspOrderItem.setInspCount(((UocCreateInspEstimateSaleItemBo)inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId())).getInspCount());
            createInspOrderItem.setRemainInspCount(((UocCreateInspEstimateSaleItemBo)inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId())).getInspCount());
            createInspOrderItem.setInitInspCount(((UocCreateInspEstimateSaleItemBo)inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId())).getInspCount());
            createInspOrderItem.setSaleOrderItemId(uocSaleOrderItem.getSaleOrderItemId());
            createInspOrderItem.setUnitName(uocSaleOrderItem.getUnitName());
            createInspOrderItem.setCreateTime(new Date());
            createInspOrderItem.setCreateOperId(reqBo.getInspOperId());
            uocInspOrderItemList.add(createInspOrderItem);
        });
        createInspOrderDo.setUocShipInspRelList(uocShipInspRelList);
        createInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        ArrayList<UocOrderAccessory> uocOrderAccessoryList = new ArrayList<UocOrderAccessory>();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            reqBo.getOrderAccessoryBoList().forEach(obj -> {
                UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setOrderId(((UocSaleOrderItem)((Object)((Object)saleOrderItems.get(0)))).getOrderId());
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
                uocOrderAccessory.setObjId(inspOrderId);
                uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.ACCEPTANCE);
                uocOrderAccessory.setAccessoryUrl(obj.getAccessoryUrl());
                uocOrderAccessory.setAccessoryName(obj.getAccessoryName());
                uocOrderAccessoryList.add(uocOrderAccessory);
            });
        }
        createInspOrderDo.setUocOrderAccessoryList(uocOrderAccessoryList);
        BigDecimal inspectionMoney = new BigDecimal(reqBo.getInspMoney());
        createInspOrderDo.setTotalSaleFee(inspectionMoney);
        createInspOrderDo.setTotalPurchaseFee(inspectionMoney);
        this.iUocInspOrderModel.createInspOrder(createInspOrderDo);
        return inspOrderId;
    }

    private void updateSaleOrderInfo(UocReceiveItInspOrderNoItemReqBo reqBo, List<UocSaleOrderItem> saleOrderItems) {
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setOrderId(reqBo.getOrderId());
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateSaleOrderDo.setUpdateOperId(reqBo.getInspOperId());
        updateSaleOrderDo.setUpdateOperName(reqBo.getInspOperName());
        updateSaleOrderDo.setUpdateTime(new Date());
        Map<Long, UocSaleOrderItem> dbSaleItemMap = saleOrderItems.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        for (UocCreateInspEstimateSaleItemBo uocCreateInspOrderReqSaleItemBo : reqBo.getSaleOrderItemList()) {
            UocSaleOrderItem dbSaleItem = dbSaleItemMap.get(uocCreateInspOrderReqSaleItemBo.getSaleOrderItemId());
            if (dbSaleItem == null) {
                throw new BaseBusinessException("101004", "\u9500\u552e\u5355\u660e\u7ec6id[" + uocCreateInspOrderReqSaleItemBo.getSaleOrderItemId() + "]\u4e0d\u5b58\u5728");
            }
            if (dbSaleItem.getAcceptanceCount().add(uocCreateInspOrderReqSaleItemBo.getInspCount()).compareTo(dbSaleItem.getPurchaseCount()) <= 0) continue;
            throw new BaseBusinessException("101004", "\u9500\u552e\u5355\u660e\u7ec6id[" + uocCreateInspOrderReqSaleItemBo.getSaleOrderItemId() + "]\u9a8c\u6536\u6570\u91cf\u8d85\u8fc7\u8d2d\u4e70\u6570\u91cf[" + dbSaleItem.getPurchaseCount() + "]\u4e86");
        }
        ArrayList<UocSaleOrderItem> updateItemList = new ArrayList<UocSaleOrderItem>();
        for (UocCreateInspEstimateSaleItemBo value : reqBo.getSaleOrderItemList()) {
            UocSaleOrderItem updateItemDo = new UocSaleOrderItem();
            updateItemDo.setSaleOrderItemId(value.getSaleOrderItemId());
            updateItemDo.setAcceptanceCount(value.getInspCount());
            updateItemList.add(updateItemDo);
        }
        updateSaleOrderDo.setSaleOrderItems(updateItemList);
        this.iUocSaleOrderModel.modifyBatchItemInspCount(updateSaleOrderDo);
    }

    private void updateSaleOrderState(List<UocSaleOrderItem> saleOrderItemList, UocReceiveItInspOrderNoItemReqBo reqBo) {
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setOrderId(reqBo.getOrderId());
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateSaleOrderDo.setUpdateOperId(reqBo.getInspOperId());
        updateSaleOrderDo.setUpdateTime(new Date());
        updateSaleOrderDo.setUpdateOperName(reqBo.getInspOperName());
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            int acceptanceCompleteItemCount = 0;
            for (UocSaleOrderItem uocSaleOrderItem : saleOrderItemList) {
                if (uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getAcceptanceCount()) != 0) continue;
                ++acceptanceCompleteItemCount;
            }
            if (acceptanceCompleteItemCount == saleOrderItemList.size()) {
                updateSaleOrderDo.setSaleOrderState("XS_YS_YS");
            } else {
                updateSaleOrderDo.setSaleOrderState("XS_YS_BFYS");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)updateSaleOrderDo.getSaleOrderState())) {
            this.iUocSaleOrderModel.updateSaleStatusAndProCode(updateSaleOrderDo);
        }
    }

    private String getInspOrderNo(UocReceiveItInspOrderNoItemReqBo reqBo) {
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        querySaleOrderDo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(querySaleOrderDo);
        if (null != saleOrderMain) {
            UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
            uocInspOrderDo.setOrderSource(saleOrderMain.getOrderSource());
            UocInspOrderDo inspOrderNo = this.iUocInspOrderModel.getInspOrderNo(uocInspOrderDo);
            if (null != inspOrderNo) {
                return inspOrderNo.getInspOrderNo();
            }
            throw new BaseBusinessException("101004", "\u751f\u6210\u9a8c\u6536\u5355\u7f16\u53f7\u5931\u8d25");
        }
        throw new BaseBusinessException("101004", "\u751f\u6210\u9a8c\u6536\u5355\u7f16\u53f7\u5931\u8d25\uff0c\u67e5\u8be2\u9500\u552e\u5355\u6570\u636e\u4e3a\u7a7a");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createOrderSettleRelInfo(UocReceiveItInspOrderNoItemReqBo reqBo, Long inspOrderId) {
        if (!this.createOrderSettleRelInfo) return;
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        querySaleOrderDo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(querySaleOrderDo);
        if (null == saleOrderMain) throw new BaseBusinessException("101004", "\u751f\u4ea7\u8ba2\u5355\u7ed3\u7b97\u5173\u8054\u6570\u636e\u5931\u8d25\uff1a\u67e5\u8be2\u9500\u552e\u5355\u5355\u4e3a\u7a7a");
        this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.SERVICE_CHARGE);
        if (UocConstant.ModelSettle.MY.equals(saleOrderMain.getModelSettle())) {
            this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.COMMON_INVOICE);
            this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.UP_INVOICE);
            return;
        } else {
            if (!UocConstant.ModelSettle.CH.equals(saleOrderMain.getModelSettle())) throw new BaseBusinessException("101004", "\u751f\u4ea7\u8ba2\u5355\u7ed3\u7b97\u5173\u8054\u6570\u636e\u5931\u8d25\uff1a\u9519\u8bef\u7684\u7ed3\u7b97\u6a21\u5f0f");
            this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.CH_INVOICE);
        }
    }

    private void createRelInfo(UocReceiveItInspOrderNoItemReqBo reqBo, Long inspOrderId, Integer relType) {
        UocOrderRel createOrderRel = new UocOrderRel();
        createOrderRel.setId(IdUtil.nextId());
        createOrderRel.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
        createOrderRel.setRelType(relType);
        createOrderRel.setOrderId(reqBo.getOrderId());
        createOrderRel.setObjId(inspOrderId);
        createOrderRel.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        this.iUocOrderModel.createRelInfo(createOrderRel);
    }

    private void verifyParam(UocReceiveItInspOrderNoItemReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getInspOperId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9a8c\u6536\u4ebaID\u4e3a\u7a7a");
        }
    }

    private UocSaleOrderDo querySaleOrderMainInfo(UocReceiveItInspOrderNoItemReqBo reqBo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = UocRu.js(reqBo, UocSaleOrderQryBo.class);
        UocSaleOrderDo saleOrderMainInfo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        if (null != saleOrderMainInfo) {
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            uocSaleOrderItemQryBo.setOrderId(saleOrderMainInfo.getOrderId());
            UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
            if (null == uocSaleOrderDo || CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
                throw new BaseBusinessException("101004", "\u83b7\u53d6\u9500\u552e\u660e\u7ec6\u4e3a\u7a7a");
            }
            saleOrderMainInfo.setSaleOrderItems(uocSaleOrderDo.getSaleOrderItems().stream().sorted(Comparator.comparing(UocSaleOrderItem::getSaleOrderItemId)).collect(Collectors.toList()));
            return saleOrderMainInfo;
        }
        throw new BaseBusinessException("101004", "\u83b7\u53d6\u9500\u552e\u8ba2\u5355\u4e3b\u4f53\u4fe1\u606f\u4e3a\u7a7a");
    }

    private List<UocSaleOrderItem> getSaleOrderItemInfos(UocReceiveItInspOrderNoItemReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
        if (null != uocSaleOrderDo && !CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            return uocSaleOrderDo.getSaleOrderItems();
        }
        throw new BaseBusinessException("101004", "\u83b7\u53d6\u9500\u552e\u660e\u7ec6\u4e3a\u7a7a");
    }
}

