/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.statecalculator;

import com.tydic.dyc.oc.components.statecalculator.UocStateCalculator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UocStateCalculatorManager {
    private static final Logger log = LoggerFactory.getLogger(UocStateCalculatorManager.class);
    private final Map<String, UocStateCalculator> manageMap = new ConcurrentHashMap<String, UocStateCalculator>();

    public void registerUocStateCalculator(UocStateCalculator calculator) {
        String className = calculator.getClass().getName();
        log.info(UocStateCalculatorManager.class.getSimpleName() + ".registerUocStateCalculator \u6ce8\u518c\u4e86\u72b6\u6001\u8ba1\u7b97\u5668\uff1a" + calculator.getClass().getSimpleName());
        this.manageMap.put(className, calculator);
    }

    public UocStateCalculator getUocStateCalculator(String className) {
        return this.manageMap.get(className);
    }
}

