/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.thread.runnable;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.constants.UocConstant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UocSyncEsRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(UocSyncEsRunnable.class);
    @Autowired
    private UocEsSyncManager uocEsSyncManager;
    private List<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<SyncEsRunnableBo>();

    @Override
    public void run() {
        String errorStr = this.validateArgList(this.syncEsRunnableBoList);
        if (ObjectUtil.isNotEmpty((Object)errorStr)) {
            log.error(errorStr);
            return;
        }
        for (SyncEsRunnableBo syncEsRunnableBo : this.syncEsRunnableBoList) {
            try {
                Integer opFlag = syncEsRunnableBo.getOpFlag();
                if (UocConstant.ES_SYNC_OP_FLAG.SAVE.equals(opFlag)) {
                    this.uocEsSyncManager.saveData(this.convertToSyncManagerBo(syncEsRunnableBo));
                    continue;
                }
                if (UocConstant.ES_SYNC_OP_FLAG.UPDATE.equals(opFlag)) {
                    this.uocEsSyncManager.updateData(this.convertToSyncManagerBo(syncEsRunnableBo));
                    continue;
                }
                if (UocConstant.ES_SYNC_OP_FLAG.DELETE.equals(opFlag)) {
                    this.uocEsSyncManager.deleteData(this.convertToSyncManagerBo(syncEsRunnableBo));
                    continue;
                }
                log.info("\u540c\u6b65es\u7ebf\u7a0b\uff1a\u65e0\u5bf9\u5e94\u64cd\u4f5c\u7c7b\u578b\u3010" + opFlag + "\u3011");
            }
            catch (Exception e) {
                log.error("Es\u540c\u6b65\u6570\u636e\u4fdd\u5b58\u53c2\u6570\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private String validateArgList(List<SyncEsRunnableBo> syncEsRunnableBoList) {
        String errorStr = null;
        if (ObjectUtil.isEmpty(syncEsRunnableBoList)) {
            errorStr = "\u591a\u7ebf\u7a0b\u540c\u6b65es\u5931\u8d25\uff1a\u5165\u53c2list\u4e3a\u7a7a";
        }
        for (SyncEsRunnableBo syncEsRunnableBo : syncEsRunnableBoList) {
            if (ObjectUtil.isEmpty((Object)syncEsRunnableBo.getObjId())) {
                errorStr = "\u591a\u7ebf\u7a0b\u540c\u6b65es\u5931\u8d25\uff1a\u5165\u53c2list\u4e3a\u7a7a";
            }
            if (ObjectUtil.isEmpty((Object)syncEsRunnableBo.getOrderId())) {
                errorStr = "\u591a\u7ebf\u7a0b\u540c\u6b65es\u5931\u8d25\uff1a\u5165\u53c2list\u4e3a\u7a7a";
            }
            if (ObjectUtil.isEmpty((Object)syncEsRunnableBo.getIndexName())) {
                errorStr = "\u591a\u7ebf\u7a0b\u540c\u6b65es\u5931\u8d25\uff1a\u5165\u53c2list\u4e3a\u7a7a";
            }
            if (!ObjectUtil.isEmpty((Object)syncEsRunnableBo.getOpFlag())) continue;
            errorStr = "\u591a\u7ebf\u7a0b\u540c\u6b65es\u5931\u8d25\uff1a\u5165\u53c2list\u4e3a\u7a7a";
        }
        return errorStr;
    }

    private UocEsSyncManagerSaveDataReqBo convertToSyncManagerBo(SyncEsRunnableBo syncEsRunnableBo) {
        UocEsSyncManagerSaveDataReqBo saveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        saveDataReqBo.setOrderId(syncEsRunnableBo.getOrderId());
        saveDataReqBo.setObjId(syncEsRunnableBo.getObjId());
        saveDataReqBo.setJsonObj(syncEsRunnableBo.getJsonObj());
        saveDataReqBo.setIndexName(syncEsRunnableBo.getIndexName());
        return saveDataReqBo;
    }

    public UocSyncEsRunnable(SyncEsRunnableBo syncEsRunnableBo) {
        this.syncEsRunnableBoList.add(syncEsRunnableBo);
    }

    public UocSyncEsRunnable(List<SyncEsRunnableBo> syncEsRunnableBoList) {
        this.syncEsRunnableBoList = syncEsRunnableBoList;
    }
}

