package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingProgressRecordDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingQuotationDo;
import com.tydic.dyc.oc.service.bargaining.bo.UocResolveBargainingApplyReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocResolveBargainingApplyRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/** 发送三方电商议价申请出参结果解析入库
 * @author DUM
 * @date 2023/8/12
 * @Version 1.0
 */
@HTServiceImpl
@Slf4j
public class UocResolveBargainingApplyServiceImpl implements UocResolveBargainingApplyService{
    @Autowired
    private IUocBargainingModel uocBargainingModel;
    @Override
    public UocResolveBargainingApplyRspBo dealBargainingApply(UocResolveBargainingApplyReqBo reqBo) {
        if(UocConstant.CREATED_RESULT.FAILED.equals(reqBo.getCreatedResult())) {
            UocBargainingDo uocBargainingDo = new UocBargainingDo();
            uocBargainingDo.setBargainingId(reqBo.getBargainingId());
            UocBargainingDo uocBargainingQryDo = uocBargainingModel.qryBargainingBy(uocBargainingDo);
            if (UocStateConstants.BARGAINING_STATES.YJ_BJZ.equals(uocBargainingQryDo.getBargainingState())){
            if (uocBargainingQryDo.getQuoteCurrentRound() == 1) {
                UocBargainingDo bargainingDo = new UocBargainingDo();
                bargainingDo.setUpdateTime(new Date());
                bargainingDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
                bargainingDo.setUpdateOperName(reqBo.getName());
                bargainingDo.setCancelTime(new Date());
                bargainingDo.setCancelReason(reqBo.getCancelReason());
                bargainingDo.setCancelOperName(reqBo.getName());
                bargainingDo.setCancelOperId(String.valueOf(reqBo.getUserId()));
                bargainingDo.setBargainingState(UocStateConstants.BARGAINING_STATES.YJ_SB); //议价提交失败
                bargainingDo.setBargainingId(reqBo.getBargainingId());
                uocBargainingModel.updateBargaining(bargainingDo);
            }
                UocBargainingQuotationDo uocBargainingQuotationDo = new UocBargainingQuotationDo();
                uocBargainingQuotationDo.setBargainingId(reqBo.getBargainingId());
                uocBargainingQuotationDo.setQuotationId(reqBo.getQuotationId());
                uocBargainingQuotationDo.setQuotationStatus(UocStateConstants.BARGAINING_QUOTATION_STATES.BJ_FAIL);
                uocBargainingQuotationDo.setQuotationReason(reqBo.getCancelReason());
                uocBargainingModel.updateQuotation(uocBargainingQuotationDo);
        }
        }else {
            //发起成功
            UocBargainingQuotationDo uocBargainingQuotationDo = new UocBargainingQuotationDo();
            uocBargainingQuotationDo.setBargainingId(reqBo.getBargainingId());
            uocBargainingQuotationDo.setQuotationId(reqBo.getQuotationId());
            uocBargainingQuotationDo.setQuotationStatus(UocStateConstants.BARGAINING_QUOTATION_STATES.BJ_YBJ);
            uocBargainingQuotationDo.setBiddingCode(reqBo.getBiddingCode());
            uocBargainingModel.updateQuotation(uocBargainingQuotationDo);
        }
        //记录操作记录
        insertProgressRecord(reqBo);
        return UocRu.success(UocResolveBargainingApplyRspBo.class);
    }
    /**
     * 记录操作动作
     * @param reqBO
     */
    private void insertProgressRecord(UocResolveBargainingApplyReqBo reqBO){
        //记录操作记录
        UocBargainingProgressRecordDo recordDo = new UocBargainingProgressRecordDo();
        recordDo.setProgressRecordId(IdUtil.nextId());
        recordDo.setBargainingId(reqBO.getBargainingId());
        recordDo.setOperType(UocConstant.BARGAINING_OPER_TYPE.CREATE);
        recordDo.setOperTypeName("议价单提交");
        recordDo.setOperId(Long.valueOf(reqBO.getUserId()));
        recordDo.setOperName(reqBO.getName());
        recordDo.setOperTime(new Date());
        recordDo.setRemark("提交结果："+reqBO.getCancelReason());
        uocBargainingModel.insertProgressRecord(recordDo);
    }
}
