package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingProgressRecordDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingQuotationDo;
import com.tydic.dyc.oc.service.bargaining.bo.UocUpdateBiddingResultReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocUpdateBiddingResultRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 标题:UocUpdateBiddingResultServiceImpl
 * 说明:中标后更新报价单状态服务实现
 * 时间:2023/9/12 9:02
 * 作者:Dum
 */
@HTServiceImpl
public class UocUpdateBiddingResultServiceImpl implements UocUpdateBiddingResultService{
    @Autowired
    private IUocBargainingModel uocBargainingModel;
    @Override
    public UocUpdateBiddingResultRspBo updateBiddingResult(UocUpdateBiddingResultReqBo reqBo) {
        this.verifyParam(reqBo);
        this.verifyState(reqBo);
        //2 .修改报价单状态"已中标"
        this.updateQuotationState(reqBo);
        //3. 记录操作记录
        insertProgressRecord(reqBo);
        //4. 返回结果
        return UocRu.success(UocUpdateBiddingResultRspBo.class);
    }
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyState(UocUpdateBiddingResultReqBo reqBO){
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setBargainingId(reqBO.getBargainingId());
        UocBargainingDo bargainingDo = uocBargainingModel.qryBargainingBy(uocBargainingDo);
        if(!UocStateConstants.BARGAINING_STATES.YJ_YBJ.equals(bargainingDo.getBargainingState())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "只能对已报价的议价单发起中标操作！");
        }
    }
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(UocUpdateBiddingResultReqBo reqBO){
        if(null == reqBO){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if(null == reqBO.getUserId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "当前操作人id不能为空");
        }
        if(StringUtils.isEmpty(reqBO.getName())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "当前操作人名称不能为空");
        }
        if(null == reqBO.getBargainingId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "议价单id不能为空");
        }
        if(null == reqBO.getQuotationId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "报价id不能为空");
        }
    }
    /**
     * 更新报价单状态
     * @param reqBO
     */
    private void updateQuotationState(UocUpdateBiddingResultReqBo reqBO){
        //更新报价单
        UocBargainingQuotationDo quotationDo = new UocBargainingQuotationDo();
            quotationDo.setBargainingId(reqBO.getBargainingId());
            quotationDo.setQuotationId(reqBO.getQuotationId());
            quotationDo.setQuotationReason("采购商手动中标");
            quotationDo.setQuotationStatus(UocStateConstants.BARGAINING_QUOTATION_STATES.BJ_WON_BID);
            quotationDo.setBargainingId(reqBO.getBargainingId());
        uocBargainingModel.updateQuotation(quotationDo);
    }
    /**
     * 记录操作动作
     * @param reqBO
     */
    private void insertProgressRecord(UocUpdateBiddingResultReqBo reqBO){
        //记录操作记录
        UocBargainingProgressRecordDo recordDo = new UocBargainingProgressRecordDo();
        recordDo.setProgressRecordId(IdUtil.nextId());
        recordDo.setBargainingId(reqBO.getBargainingId());
        recordDo.setOperType(UocConstant.BARGAINING_OPER_TYPE.ORDER);
        recordDo.setOperTypeName("中标报价");
        recordDo.setOperId(Long.valueOf(reqBO.getUserId()));
        recordDo.setOperName(reqBO.getName());
        recordDo.setOperTime(new Date());
        recordDo.setRemark("中标ID："+reqBO.getQuotationId());
        uocBargainingModel.insertProgressRecord(recordDo);
    }
}
