package com.tydic.dyc.oc.service.order;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfButtonQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfButton;
import com.tydic.dyc.oc.service.order.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;

/**
 * 标题：UocProOrderButtonSettingsServiceImpl
 * 说明：订单按钮配置数据查询、订单按钮配置更新操作
 * 时间：2022/4/7 18:39
 *
 * @author tkl
 */

@HTServiceImpl
public class UocProOrderButtonSettingsServiceImpl implements UocProOrderButtonSettingsService {

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocProQueryOrderButtonSettingsRspBo queryOrderButtonSettings(UocProQueryOrderButtonSettingsReqBo reqBo) {
        UocProQueryOrderButtonSettingsRspBo rspBo = UocRu.success(UocProQueryOrderButtonSettingsRspBo.class);
        UocConfButtonQryBo qryBo = new UocConfButtonQryBo();
        qryBo = JSONObject.parseObject(JSON.toJSONString(reqBo),UocConfButtonQryBo.class);
        List<UocConfButton> uocConfButtons = iUocOrderModel.qryConfButtonList(qryBo);
        if (ObjectUtil.isNotEmpty(uocConfButtons)) {
            rspBo.setRows(UocRu.jsl(uocConfButtons, UocProConfButtonBO.class));
        }
        return rspBo;
    }

    @Override
    public UocProEditOrderButtonSettingsRspBo editOrderButtonSettings(UocProEditOrderButtonSettingsReqBo reqBo) {
        UocConfButton confButton = UocRu.js(reqBo, UocConfButton.class);
        confButton.setOperId(reqBo.getUsername());
        //按钮编码不能变
        confButton.setButtonCode(null);
        confButton.setOperTime(new Date());
        iUocOrderModel.updateConfButton(confButton);
        return UocRu.success(UocProEditOrderButtonSettingsRspBo.class);
    }

}
