/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.model.insporder.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.UocInspOrderRepository;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocInspOrderModelImpl
implements IUocInspOrderModel {
    private static final Logger log = LoggerFactory.getLogger(UocInspOrderModelImpl.class);
    @Autowired
    private UocInspOrderRepository uocInspOrderRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;

    @Override
    public void createInspOrder(UocInspOrderDo uocInspOrderDo) {
        this.valDo(uocInspOrderDo);
        this.uocInspOrderRepository.createInspOrder(uocInspOrderDo);
        this.uocCommonRepository.addBatchOrderAccessory(uocInspOrderDo.getUocOrderAccessoryList());
    }

    @Override
    public UocInspOrderDo getInspOrderMain(UocInspOrderQryBo uocInspOrderQryBo) {
        if (null == uocInspOrderQryBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocInspOrderRepository.getInspOrderMain(uocInspOrderQryBo);
    }

    @Override
    public UocInspOrderDo getListInspOrderItem(UocInspOrderItemQryBo uocInspOrderItemQryBo) {
        if (null == uocInspOrderItemQryBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UocInspOrderDo uocInspOrderDo = this.uocInspOrderRepository.getListInspOrderItem(uocInspOrderItemQryBo);
        log.info("\u9a8c\u6536\u660e\u7ec6\u67e5\u8be2\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocInspOrderDo));
        return uocInspOrderDo;
    }

    @Override
    public UocInspOrderDo getInspOrderItemList(UocInspOrderItemQryBo uocInspOrderItemQryBo) {
        if (null == uocInspOrderItemQryBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UocInspOrderDo uocInspOrderDo = this.uocInspOrderRepository.getInspOrderItemList(uocInspOrderItemQryBo);
        log.info("\u9a8c\u6536\u660e\u7ec6\u67e5\u8be2\u51fa\u53c22\uff1a{}", (Object)JSON.toJSONString((Object)uocInspOrderDo));
        return uocInspOrderDo;
    }

    @Override
    public List<UocInspOrderDo> getListInspOrder(UocInspOrderQryBo uocInspOrderQryBo) {
        if (null == uocInspOrderQryBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        return this.uocInspOrderRepository.getListInspOrder(uocInspOrderQryBo);
    }

    @Override
    public UocInspOrderDo getInspOrderNo(UocInspOrderDo uocInspOrderDo) {
        if (null == uocInspOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocInspOrderDo.getOrderSource()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderNo = this.uocCommonRepository.getOrderNoSingle("ORDER_INSPECTION_NO_" + uocInspOrderDo.getOrderSource());
        uocInspOrderDo.setInspOrderNo(orderNo);
        return uocInspOrderDo;
    }

    @Override
    public UocInspOrderDo qryTotalFeeAndCount(UocInspOrderQryBo uocInspOrderQryBo) {
        if (null == uocInspOrderQryBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocInspOrderRepository.qryTotalFeeAndCount(uocInspOrderQryBo);
    }

    @Override
    public void modifySaleOrderItemReturningCount(UocInspOrderItem uocSaleOrderItem) {
        this.uocInspOrderRepository.modifySaleOrderItemReturningCount(uocSaleOrderItem);
    }

    private void valDo(UocInspOrderDo uocInspOrderDo) {
        if (null == uocInspOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocInspOrderDo.getOrderId()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void modifyInspOrderItemChngingCount(UocInspOrderDo convertInspOrderDo) {
        this.uocInspOrderRepository.modifyInspOrderItemChngingCount(convertInspOrderDo);
    }

    @Override
    public void modifyItemChngCountRefuse(UocInspOrderDo convertInspOrderDo) {
        this.uocInspOrderRepository.modifyItemChngCountRefuse(convertInspOrderDo);
    }

    @Override
    public void modifyItemChngCountConfirm(UocInspOrderDo convertInspOrderDo) {
        this.uocInspOrderRepository.modifyItemChngCountConfirm(convertInspOrderDo);
    }

    @Override
    public void modifyBatchItemInspConfirm(UocInspOrderDo convertInspOrderDo) {
        this.uocInspOrderRepository.modifyBatchItemInspConfirm(convertInspOrderDo);
    }

    @Override
    public void modifyItemChngCountConfirmAdd(UocInspOrderDo convertInspOrderDo) {
        this.uocInspOrderRepository.modifyItemChngCountConfirmAdd(convertInspOrderDo);
    }

    @Override
    public void modifyItemChngCountConfirmReduce(UocInspOrderDo convertInspOrderDo) {
        this.uocInspOrderRepository.modifyItemChngCountConfirmReduce(convertInspOrderDo);
    }

    @Override
    public void modifyInsporderChngTotalFeeConfirm(UocInspOrderDo convertInspOrderDo) {
        this.uocInspOrderRepository.modifyInsporderChngTotalFeeConfirm(convertInspOrderDo);
    }

    @Override
    public void updateInspPayStatus(UocInspOrderDo updateInspOrderDo) {
        this.uocInspOrderRepository.updateInspPayStatus(updateInspOrderDo);
    }

    @Override
    public void batchSyncInsp() {
        this.uocInspOrderRepository.batchSyncInsp();
    }

    @Override
    public void modifyItemRemainCountAdd(UocInspOrderDo convertInspOrderDo) {
        this.uocInspOrderRepository.modifyItemRemainCountAdd(convertInspOrderDo);
    }

    @Override
    public void modifyItemRemainCountReduce(UocInspOrderDo convertInspOrderDo) {
        this.uocInspOrderRepository.modifyItemRemainCountReduce(convertInspOrderDo);
    }
}

