/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocQryOrderCreateResultByStateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultByStateServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultByStateServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultServiceRspProcessDataBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocQryOrderCreateResultByStateService"})
public class UocQryOrderCreateResultByStateServiceImpl
implements UocQryOrderCreateResultByStateService {
    private static final Logger log = LoggerFactory.getLogger(UocQryOrderCreateResultByStateServiceImpl.class);
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"qryOrderCreateResult"})
    public UocQryOrderCreateResultByStateServiceRspBo qryOrderCreateResult(@RequestBody UocQryOrderCreateResultByStateServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UocQryOrderCreateResultByStateServiceRspBo rspBo = UocRu.success(UocQryOrderCreateResultByStateServiceRspBo.class);
        UocOrderDo qryOrderDo = new UocOrderDo();
        qryOrderDo.setOrderId(reqBo.getOrderId());
        UocOrderDo uocOrderDo = this.iUocOrderModel.qryOrderBy(qryOrderDo);
        if (ObjectUtil.isEmpty((Object)((Object)uocOrderDo))) {
            return rspBo;
        }
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setOrderNo(uocOrderDo.getOrderNo());
        rspBo.setTotalSaleFee(uocOrderDo.getTotalSaleFee());
        boolean processResult = true;
        UocSaleOrderDo qrySaleDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        List<UocSaleOrderDo> uocSaleOrderDos = this.iUocSaleOrderModel.qrySaleOrderList(qrySaleDo);
        ArrayList failedList = new ArrayList();
        for (UocSaleOrderDo uocSaleOrderDo : uocSaleOrderDos) {
            UocQryOrderCreateResultServiceRspProcessDataBo resultDataBo = new UocQryOrderCreateResultServiceRspProcessDataBo();
            if (UocConstant.CREATED_RESULT.PROCESSING.equals(uocSaleOrderDo.getCreatedResult())) {
                processResult = false;
            }
            if (UocConstant.CREATED_RESULT.FAILED.equals(uocSaleOrderDo.getCreatedResult())) {
                resultDataBo.setMsg(uocSaleOrderDo.getCancelReason());
                resultDataBo.setResultCode(Integer.valueOf(3));
                resultDataBo.setResultDescription("\u5931\u8d25");
                UocSaleOrderItemQryBo saleOrderItemQryBo = new UocSaleOrderItemQryBo();
                saleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
                List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(saleOrderItemQryBo);
                resultDataBo.setCommodityInfo(UocRu.jsl(saleOrderItemList, UocGetSaleOrderDetailServiceRspItemBo.class));
                resultDataBo.setSupNo(uocSaleOrderDo.getStakeholder().getSupId());
                rspBo.getFailedList().add(resultDataBo);
                continue;
            }
            resultDataBo.setResultCode(Integer.valueOf(1));
            resultDataBo.setResultDescription("\u6210\u529f");
        }
        rspBo.setProcessResult(Boolean.valueOf(processResult));
        return rspBo;
    }

    private void validateArg(UocQryOrderCreateResultByStateServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocQryOrderCreateResultByStateServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355id\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

