package com.tydic.dyc.oc.service.common;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.common.bo.UocQryBusiCodeReqBo;
import com.tydic.dyc.oc.service.common.bo.UocQryBusiCodeRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@Slf4j
@HTServiceImpl
public class UocQryBusiCodeServiceImpl implements UocQryBusiCodeService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Override
    public UocQryBusiCodeRspBo qryBusiCode(UocQryBusiCodeReqBo reqBo) {
        validateArgs(reqBo);
        UocQryBusiCodeRspBo rspBo = UocRu.success(UocQryBusiCodeRspBo.class);
        //获取业务实例信息
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setTaskInstId(reqBo.getTaskId());
        uocOrderTaskInst.setProcInstId(reqBo.getProcInstId());
        List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
        if (!ObjectUtil.isEmpty(uocOrderTaskInsts)){
            UocOrderTaskInst taskInst = uocOrderTaskInsts.get(0);
            if (UocDicConstant.OBJ_TYPE.APPROVE.equals(taskInst.getObjType())){
                //获取审批单编号
                if (!ObjectUtil.isEmpty(taskInst.getObjId())){
                    UocAuditOrderQryBo uocAuditOrderQryBo = new UocAuditOrderQryBo();
                    uocAuditOrderQryBo.setAuditOrderId(taskInst.getObjId());
                    UocAuditOrderDo uocAuditOrderDo = iUocAuditOrderModel.qryAuditOrder(uocAuditOrderQryBo);
                    if (!ObjectUtil.isEmpty(uocAuditOrderDo)){
                        rspBo.setObjNo(uocAuditOrderDo.getAuditOrderCode());
                    }
                }
            }
        }
        return rspBo;
    }

    private void validateArgs(UocQryBusiCodeReqBo uocQryBusiCodeReqBo){
        if (null == uocQryBusiCodeReqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(uocQryBusiCodeReqBo.getTaskId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "任务ID不能为空");
        }
    }
}
