package com.tydic.dyc.oc.service.insporder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.insporder.bo.UocInspUploadPicServiceReqBO;
import com.tydic.dyc.oc.service.insporder.bo.UocInspUploadPicServiceRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/*
 * @Author lsl
 * @Description : 验收单图片上传
 * @Date 11:16 2023/7/27
 * @Param
 * @return
 */
@Slf4j
@HTServiceImpl
public class UocInspUploadPicServiceImpl implements UocInspUploadPicService {

    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocInspUploadPicServiceRspBO uploadInspPicture(UocInspUploadPicServiceReqBO reqBo) {
        UocInspUploadPicServiceRspBO rspBO = UocRu.success(UocInspUploadPicServiceRspBO.class);
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(reqBo.getOrderId());
        uocInspOrderQryBo.setInspOrderId(reqBo.getObjId());
        log.info("验收单表入参查询", uocInspOrderQryBo);
        List<UocInspOrderDo> inspOrderList = this.iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
        log.info("验收单表出参查询", uocInspOrderQryBo);
        if (ObjectUtil.isNotEmpty(inspOrderList)) {
            List<UocBaseOrderAccessoryAddBo> otherAccessoryAddBoList = reqBo.getAttachBOList().stream().filter(e -> {
                if (UocAttachementTypeConstants.ACCEPTANCE_OTHER.equals(e.getAttachmentType())) {
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            //如果有上传新的验收报告附件，则把旧的验收报告附件删除掉
            if (ObjectUtil.isNotEmpty(otherAccessoryAddBoList)) {
                UocOrderAccessory needDelAccessory = new UocOrderAccessory();
                needDelAccessory.setObjId(reqBo.getObjId());
                needDelAccessory.setAttachmentType(UocAttachementTypeConstants.ACCEPTANCE_OTHER);
                needDelAccessory.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
                //删除旧的验收报告
                iUocOrderModel.deleteOrderAccessory(needDelAccessory);
            }

            List<UocOrderAccessory> uocOrderAccessoryList = new ArrayList<>();
            for (UocBaseOrderAccessoryAddBo each : reqBo.getAttachBOList()) {
                UocOrderAccessory needAddAccessory = UocRu.js(each, UocOrderAccessory.class);
                needAddAccessory.setId(IdUtil.nextId());
                needAddAccessory.setOrderId(reqBo.getOrderId());
                needAddAccessory.setObjId(reqBo.getObjId());
                needAddAccessory.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
                needAddAccessory.setAttachmentType(each.getAttachmentType());
                uocOrderAccessoryList.add(needAddAccessory);
            }
            //生成新的验收照片
            iUocOrderModel.createOrderAccessory(UocRu.jsl(uocOrderAccessoryList, UocOrderAccessory.class));
            //修改验收备注，直接覆盖之前的备注值
            UocInspOrderDo inspOrderDo = new UocInspOrderDo();
            inspOrderDo.setOrderId(reqBo.getOrderId());
            inspOrderDo.setInspOrderId(reqBo.getObjId());
            inspOrderDo.setRemark(reqBo.getRemark());
            iUocInspOrderModel.updateInspRemark(inspOrderDo);
        } else {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SYSTEM_EXCEPTION, "入参【objId】+【orderId】查询验收单为空");
        }


        // 交行改造 查发已办需要的出参
        if (reqBo.getObjId() != null) {
            // 查销售单编码
            UocSaleOrderDo qryDo = new UocSaleOrderDo();
            qryDo.setSaleOrderId(reqBo.getObjId());
            List<UocSaleOrderDo> uocSaleOrderDos = iUocSaleOrderModel.qrySaleOrderList(qryDo);

            if (!CollectionUtils.isEmpty(uocSaleOrderDos)) {
                rspBO.setSaleOrderNo(uocSaleOrderDos.get(0).getSaleOrderNo());
            }
        }

        return rspBO;
    }
}
