package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.service.bargaining.bo.*;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 描述：议价单-报价记录查询服务
 *
 * @author gaoqh646
 * @date 2023/8/7 9:54
 **/
@HTServiceImpl
@Slf4j
public class UocQryQuotationListServiceImpl implements UocQryQuotationListService{

    @Autowired
    private IUocBargainingModel uocBargainingModel;


    @Override
    public UocQryQuotationListServiceRspBo qryQuotationList(UocQryQuotationListServiceReqBo reqBo) {
        verifyParam(reqBo);
        UocQryQuotationListServiceRspBo resp=new UocQryQuotationListServiceRspBo();
        List<UocQryQuotationBo> resList = uocBargainingModel.qryListBargainingQuotatio(reqBo);
        resp.setUocQryQuotationBoList(resList);
        return resp;
    }

    /**
     * 参数校验
     * @param reqBo
     */
    private void verifyParam(UocQryQuotationListServiceReqBo reqBo) {
        if(null == reqBo){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if(null == reqBo.getBargainingId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "议价单ID不能为空");
        }

    }

}
