package com.tydic.dyc.oc.model.bargaining;

import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingAddress;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargainingItem;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：议价单领域对象
 *
 * @author Dum
 * @date 2023/7/30 16:09
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocBargainingDo implements Serializable {
    /**
     * 议价单id
     */
    private Long bargainingId;
    /**
     * 议价单编码
     */
    private String bargainingNo;
    /**
     * 议价单父id
     */
    private Long bargainingParentId;
    /**
     * 流程实例id
     */
    private String procInstId;
    /**
     *  议价单类型 :1.采购电商 2, 无协议
     采购方发起，供应发起
     */
    private Integer bargainingType;
    /**
     * 结算模式 2:撮合 1:贸易
     */
    private Integer modelSettle;
    /**
     * 议价单状态
     *  YJ_DBJ 待发起
     *  YJ_DBJ 报价中
     *  YJ_YBJ 已报价
     *  YJ_YZZ 已终止
     *  YJ_YXD 已下单
     */
    private String bargainingState;
    /**
     *议价单状态名称（翻译）
     */
    private String bargainingStateStr;
    /**
     * 采购方公司id
     */
    private String purCompanyId;
    /**
     * 采购公司编码
     */
    private String purCompanyNo;
    /**
     * 采购方公司名称
     */
    private String purCompanyName;
    /**
     * 采购方机构id
     */
    private String purOrgId;
    /**
     * 采购方机构编码
     */
    private String purOrgNo;
    /**
     * 采购方机构名称
     */
    private String purOrgName;
    /**
     * 供应商ID
     */
    private String supId;
    /**
     * 供应商编码
     */
    private String supNo;
    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 运营单位机构id
     */
    private String proId;
    /**
     * 运营单位机构编码
     */
    private String proNo;
    /**
     * 运营机构名称
     */
    private String proName;
    /**
     * 送货时间
     */
    private Date quotationExpiryTime;
    private Date quotationExpiryTimeStart;
    private Date quotationExpiryTimeEnd;
    /**
     * 收货地址ID
     */
    private Long addressId;
    /**
     * 报价最大轮次
     */
    private Integer quoteMaxRound;
    /**
     * 报价当前轮次
     */
    private Integer quoteCurrentRound;
    /**
     * 议价前商品总金额
     */
    private BigDecimal totalPrice;
    /**
     * 最终总专属报价，供应商报价成功后更新
     */
    private BigDecimal totalConfirmedPrice;
    /**
     * 总价折扣率
     */
    private BigDecimal totalDiscountRate;
    /**
     * 终止人ID
     */
    private String cancelOperId;
    /**
     * 终止人
     */
    private String cancelOperName;
    /**
     * 终止时间
     */
    private Date cancelTime;
    private Date cancelTimeStart;
    private Date cancelTimeEnd;
    /**
     * 终止原因
     */
    private String cancelReason;
    /**
     * 议价人ID
     */
    private String bargainingOperId;
    /**
     * 议价人名称
     */
    private String bargainingOperName;
    /**
     * 创建时间
     */
    private Date createTime;
    private Date createTimeStart;
    private Date createTimeEnd;
    /**
     * 更新人ID
     */
    private String updateOperId;
    /**
     * 更新人名称
     */
    private String updateOperName;
    /**
     * 更新时间
     */
    private Date updateTime;
    private Date updateTimeStart;
    private Date updateTimeEnd;
    //订单创建结果 0创建中，1成功，2失败")
    private Integer createdResult;

    /**
     * 议价单明细
     */
    private List<UocBargainingItem> bargainingItems;

    /**
     * 预计收货人地址信息
     */
    private UocBargainingAddress bargainingAddress;
    /**
     * 扩展字段1:未比选原因
     */
    private String extField1;
}
