package com.tydic.dyc.oc.model.order.sub;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocOrderAgreement
 * 说明:协议信息表
 * 时间:2022-03-28 11:35
 * 作者:tkl
 **/
@Data
public class UocOrderAgreement implements Serializable {
	private static final long serialVersionUID = 393595702554002922L;

	@DocField(value = "Id")
	private Long id;

	@DocField(value = "协议Id")
	private String agreementId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "协议模式 1：平台协议 2：单位协议")
	private Integer agreementCode;

	@DocField(value = "协议版本号")
	private String agreementVersion;

	@DocField(value = "平台协议编号")
	private String plaAgreementCode;

	@DocField(value = "企业协议编号")
	private String entAgreementCode;

	@DocField(value = "协议名称")
	private String agreementName;

	@DocField(value = "是否存在加价项 0：否 1：是")
	private Integer isAddPrice;

	@DocField(value = "配置状态 0：已分配 1：待分配 ")
	private Integer assignStatus;

	@DocField(value = "是否公式调价 0：否 1：是")
	private Integer isAdjustPriceFormula;

	@DocField(value = "是否手动修改采购单价 0:否 1：是")
	private Integer isModifyBuyPrice;

	@DocField(value = "调价公式名称")
	private String adjustPriceFormulaName;

	@DocField(value = "调价公式值")
	private String adjustPriceFormulaValue;

	@DocField(value = "税率 ")
	private Integer taxRate;

	@DocField(value = "币种，0：人民币 默认0")
	private Integer currency;

	@DocField(value = "协议生效日期")
	private Date effDate;

	@DocField(value = "协议失效日期")
	private Date expDate;

	@DocField(value = "预付款(对项目单位)")
	private BigDecimal prePayEnt;

	@DocField(value = "投料款(对项目单位)")
	private BigDecimal matPayEnt;

	@DocField(value = "进度款(对项目单位)")
	private BigDecimal proPayEnt;

	@DocField(value = "到货验收款(对项目单位)")
	private BigDecimal verPayEnt;

	@DocField(value = "试运行验收款(对项目单位)")
	private BigDecimal pilPayEnt;

	@DocField(value = "质保金(对项目单位)")
	private BigDecimal quaPayEnt;

	@DocField(value = "投料款(对供应商)")
	private BigDecimal matPaySup;

	@DocField(value = "进度款(对供应商)")
	private BigDecimal proPaySup;

	@DocField(value = "到货验收款(对供应商)")
	private BigDecimal verPaySup;

	@DocField(value = "试运行验收款(对供应商)")
	private BigDecimal pilPaySup;

	@DocField(value = "质保金(对供应商)")
	private BigDecimal quaPaySup;

	@DocField(value = "预付款(对供应商)")
	private BigDecimal prePaySup;

	@DocField(value = "供货周期 单位天")
	private Integer supplyCycle;

	@DocField(value = "质保期(月)")
	private Integer warantty;

	@DocField(value = "是否配送 0:否,1是 默认值：是 ")
	private Integer isDispatch;

	@DocField(value = "成交服务费比率 选项：0, 2.5, 5.0")
	private BigDecimal serviceRate;

	@DocField(value = "结算单位id")
	private Long unitAccountId;

	@DocField(value = "结算单位名称")
	private String unitAccountName;

	@DocField(value = "铺货单位id")
	private Long supplierId;

	@DocField(value = "铺货单位名称")
	private String supplierName;

	@DocField(value = "供货商id")
	private Long vendorId;

	@DocField(value = "供货商名称")
	private String vendorName;

	@DocField(value = "供货商联系人")
	private String vendorContact;

	@DocField(value = "供货商联系电话")
	private String vendorPhone;

	@DocField(value = "铺货部门id")
	private Long vendorDepartmentId;

	@DocField(value = "铺货部门名称")
	private String vendorDepartmentName;

	@DocField(value = "协议创建日期")
	private Date createTime;

	@DocField(value = "调价，2事中")
	private Integer adjustPrice;

	@DocField(value = "铺货联系人")
	private String vendorContactPerson;

	@DocField(value = "铺货联系方式")
	private String vendorContactWay;

	@DocField(value = "铺货联系地址")
	private String vendorContactAddress;

	@DocField(value = "协议经办人")
	private Long producerId;

	@DocField(value = "协议经办人名字")
	private String producerName;

	@DocField(value = "协议经办人电话")
	private String producerPhone;

	@DocField(value = "交易模式 1：贸易模式 2：搓合模式")
	private Integer tradeMode;

	@DocField(value = "应用范围类型：0：全部:1：省份、2：行业:3：分子公司:4：项目单位 默认值：无")
	private Integer scopeType;

	@DocField("合同id")
	private Long contractId;

	@DocField("合同编号")
	private String contractNo;
}
