package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPasteCancelApplySaleOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPasteCancelApplySaleOrderRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * 描述: 〈领域服务-销售单取消申请撤回实现〉
 * @author : yuhao
 * @date : 2022/8/1 10:00
 */
@HTServiceImpl
public class UocPasteCancelApplySaleOrderServiceImpl implements UocPasteCancelApplySaleOrderService {

	@Autowired
	private IUocSaleOrderModel iUocSaleOrderModel;

	@Autowired
	private IUocChngOrderModel iUocChngOrderModel;

	@Override
	public UocPasteCancelApplySaleOrderRspBo dealPasteCancelApply(UocPasteCancelApplySaleOrderReqBo reqBo) {
		//参数校验
		this.verifyParam(reqBo);
		//删除取消申请变更单
		this.deleteCancelApplyChangeOrder(reqBo);
		//更新销售单信息
		this.updateSaleOrder(reqBo);

		UocPasteCancelApplySaleOrderRspBo rspBo = new UocPasteCancelApplySaleOrderRspBo();
		rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
		rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
		return rspBo;
	}

	/**
	 * 更新销售单信息
	 * @param reqBo
	 */
	private void updateSaleOrder(UocPasteCancelApplySaleOrderReqBo reqBo){
		UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
		updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
		updateSaleOrderDo.setOrderId(reqBo.getOrderId());
		updateSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_FH_DFH);
		updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
		updateSaleOrderDo.setUpdateTime(new Date());
		updateSaleOrderDo.setUpdateOperName(reqBo.getName());
		this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
	}

	/**
	 * 取消申请变更单删除
	 * @param reqBo
	 */
	private void deleteCancelApplyChangeOrder(UocPasteCancelApplySaleOrderReqBo reqBo){
		UocChngOrderDo deleteChngOrderDo = new UocChngOrderDo();
		if (null == reqBo.getChngOrderId()){
			UocChngOrderQryBo uocChngOrderQryBo=new UocChngOrderQryBo();
			uocChngOrderQryBo.setOrderId(reqBo.getOrderId());
			uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL);
			uocChngOrderQryBo.setChngOrderState(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.CHNG_XS_QXSQZ);
			UocChngOrderDo uocChngOrderDo = iUocChngOrderModel.getChngOrder(uocChngOrderQryBo);
			reqBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
		}
		deleteChngOrderDo.setOrderId(reqBo.getOrderId());
		deleteChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.CHNG_XS_YCX);
		deleteChngOrderDo.setChngOrderId(reqBo.getChngOrderId());
		deleteChngOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
		deleteChngOrderDo.setUpdateTime(new Date());
		deleteChngOrderDo.setUpdateOperName(reqBo.getName());
		this.iUocChngOrderModel.updateChngOrderMain(deleteChngOrderDo);
	}

	/**
	 * 参数校验
	 * @param reqBo
	 */
	private void verifyParam(UocPasteCancelApplySaleOrderReqBo reqBo) {
		if (null == reqBo) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
		}
		if (null == reqBo.getOrderId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
		}
		if (null == reqBo.getSaleOrderId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
		}
//		if (null == reqBo.getChngOrderId()) {
//			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更单ID不能为空");
//		}
		if (null == reqBo.getUserId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID不能为空");
		}
		if(StringUtils.isEmpty(reqBo.getName())){
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID不能为空");
		}
	}
}
