package com.tydic.dyc.oc.service.common;

import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.order.sub.UocTodo;
import com.tydic.dyc.oc.service.common.bo.UocQryTodoListInfoReqBo;
import com.tydic.dyc.oc.service.common.bo.UocQryTodoListInfoRspBo;
import com.tydic.dyc.oc.service.common.bo.UocTodoBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 描述: 〈领域服务-查询多条待办信息 实现〉
 * @author : 王久鑫
 * @date : 2022/10/27 14:05
 */
@HTServiceImpl
public class UocQryTodoListInfoServiceImpl implements UocQryTodoListInfoService{
    @Autowired
    private IUocCommonModel uocCommonModel;
    @Override
    public UocQryTodoListInfoRspBo qryTodoListInfo(UocQryTodoListInfoReqBo uocQryTodoListInfoReqBo) {
        UocTodo uocTodo = new UocTodo();
        BeanUtils.copyProperties(uocQryTodoListInfoReqBo,uocTodo);
        List<UocTodo> todoListInfo = uocCommonModel.getTodoListInfo(uocTodo);
        UocQryTodoListInfoRspBo rspBO = new UocQryTodoListInfoRspBo();
        if (!CollectionUtils.isEmpty(todoListInfo)){
            List<UocTodoBo> uocTodoBoList = UocRu.jsl(todoListInfo, UocTodoBo.class);
            rspBO.setUocTodoBoList(uocTodoBoList);
        }
        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
