/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.common;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.sub.UocConfSupplierDO;
import com.tydic.dyc.oc.service.common.UocQrySupplierQuotaConfigService;
import com.tydic.dyc.oc.service.common.bo.UocQrySupplierQuotaConfigReqBo;
import com.tydic.dyc.oc.service.common.bo.UocQrySupplierQuotaConfigReqSkuBo;
import com.tydic.dyc.oc.service.common.bo.UocQrySupplierQuotaConfigRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="OC_GROUP_DEV", serviceInterface=UocQrySupplierQuotaConfigService.class)
public class UocQrySupplierQuotaConfigServiceImpl
implements UocQrySupplierQuotaConfigService {
    @Autowired
    private IUocCommonModel uocCommonModel;

    public UocQrySupplierQuotaConfigRspBo checkSupQuotaLimit(UocQrySupplierQuotaConfigReqBo reqBo) {
        this.validateArgs(reqBo);
        Set supplierSet = reqBo.getItemList().stream().map(UocQrySupplierQuotaConfigReqSkuBo::getGoodsSupplierId).collect(Collectors.toSet());
        UocConfSupplierDO uocConfSupplierDO = new UocConfSupplierDO();
        uocConfSupplierDO.setSupplierNos(new ArrayList<String>(supplierSet));
        List<UocConfSupplierDO> uocConfSupplierDoS = this.uocCommonModel.qryConfSupplierList(uocConfSupplierDO);
        Map supConfigMap = uocConfSupplierDoS.stream().collect(Collectors.toMap(UocConfSupplierDO::getSupNo, Function.identity()));
        Map<String, List<UocQrySupplierQuotaConfigReqSkuBo>> supMap = reqBo.getItemList().stream().collect(Collectors.groupingBy(UocQrySupplierQuotaConfigReqSkuBo::getGoodsSupplierId));
        for (Map.Entry<String, List<UocQrySupplierQuotaConfigReqSkuBo>> tMap : supMap.entrySet()) {
            String key = tMap.getKey();
            List<UocQrySupplierQuotaConfigReqSkuBo> value = tMap.getValue();
            UocConfSupplierDO confSupplierDO = (UocConfSupplierDO)supConfigMap.get(key);
            if (confSupplierDO == null) continue;
            BigDecimal totalPrice = new BigDecimal(0);
            for (UocQrySupplierQuotaConfigReqSkuBo skuBo : value) {
                if (confSupplierDO.getOrderLimit() == null) continue;
                totalPrice = skuBo.getPurchaseCount().multiply(skuBo.getSkuSalePrice()).add(totalPrice);
            }
            if (!StringUtils.isNotBlank((CharSequence)confSupplierDO.getOrderLimit()) || new BigDecimal(confSupplierDO.getOrderLimit()).subtract(totalPrice).compareTo(BigDecimal.ZERO) <= 0) continue;
            return UocRu.failed("8888", confSupplierDO.getSupName() + "\u4e0b\u7684\u8ba2\u5355\u4e0d\u6ee1\u8db3[" + confSupplierDO.getOrderLimit() + "]\u5143\uff0c\u4e0d\u5141\u8bb8\u4e0b\u5355\u3002", UocQrySupplierQuotaConfigRspBo.class);
        }
        return UocRu.success(UocQrySupplierQuotaConfigRspBo.class);
    }

    private void validateArgs(UocQrySupplierQuotaConfigReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List itemList = reqBo.getItemList();
        if (ObjectUtil.isEmpty((Object)itemList)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5c5e\u6027itemList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocQrySupplierQuotaConfigReqSkuBo tBo : itemList) {
            if (ObjectUtil.isEmpty((Object)tBo)) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tBo.getGoodsSupplierId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[goodsSupplierId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tBo.getPurchaseCount())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[purchaseCount]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tBo.getSkuId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)tBo.getSkuSalePrice())) continue;
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[skuSalePrice]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

