/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.repository.UocAfOrderRepository;
import com.tydic.dyc.oc.repository.UocSaleOrderRepository;
import com.tydic.dyc.oc.repository.UocShipOrderRepository;
import com.tydic.dyc.oc.service.domainservice.UocAfterOrderFinishConfirmService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderFinishConfirmReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderFinishConfirmRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="OC_GROUP_DEV", serviceInterface=UocAfterOrderFinishConfirmService.class)
public class UocAfterOrderFinishConfirmServiceImpl
implements UocAfterOrderFinishConfirmService {
    @Autowired
    private IUocAfOrderModel afOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private UocSaleOrderRepository saleOrderRepository;
    @Autowired
    private UocShipOrderRepository shipOrderRepository;
    @Autowired
    private UocAfOrderRepository uocAfOrderRepository;

    public UocAfterOrderFinishConfirmRspBo finishConfirmAfterOrder(UocAfterOrderFinishConfirmReqBo reqBo) {
        this.val(reqBo);
        UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
        uocAfOrderDo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderDo.setOrderId(reqBo.getOrderId());
        uocAfOrderDo.setServState(UocDicConstant.SERVICE_STATE.COMPLATE);
        if (null != reqBo.getFlag() && reqBo.getFlag() == 1) {
            uocAfOrderDo.setServState(UocDicConstant.SERVICE_STATE.REMARK_COMPLATE);
        }
        uocAfOrderDo.setFinishTime(new Date());
        this.afOrderModel.modifyAfOrderState(uocAfOrderDo);
        if (null != reqBo.getFlag() && reqBo.getFlag() == 1) {
            this.updateAfteringCount(reqBo);
        }
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(reqBo.getTaskId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(11111L);
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
        return UocRu.success(UocAfterOrderFinishConfirmRspBo.class);
    }

    private void val(UocAfterOrderFinishConfirmReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getAfOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u552e\u540e\u5355ID\u4e3a\u7a7a");
        }
    }

    private void updateAfteringCount(UocAfterOrderFinishConfirmReqBo reqBo) {
        UocAfOrderDo afOrderDo = new UocAfOrderDo();
        afOrderDo.setOrderId(reqBo.getOrderId());
        afOrderDo.setAfOrderId(reqBo.getAfOrderId());
        UocAfOrderQryBo uocAfOrderQryBo = UocRu.js(afOrderDo, UocAfOrderQryBo.class);
        UocAfOrder afOrder = this.uocAfOrderRepository.getAfOrderById(uocAfOrderQryBo);
        UocAfOrderItemQryBo uocAfOrderItemQryBo = UocRu.js(afOrderDo, UocAfOrderItemQryBo.class);
        List<UocAfOrderItem> afOrderItemList = this.uocAfOrderRepository.getAfOrderItemList(uocAfOrderItemQryBo);
        for (UocAfOrderItem uocAfOrderItem : afOrderItemList) {
            Long orderItemId = uocAfOrderItem.getSaleItemId();
            Long shipItemId = uocAfOrderItem.getShipItemId();
            Long orderId = uocAfOrderItem.getOrderId();
            BigDecimal returnCount = uocAfOrderItem.getReturnCount();
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setOrderId(orderId);
            uocShipOrderItem.setShipOrderItemId(shipItemId);
            uocShipOrderItem.setAfterServingCount(returnCount.negate());
            Integer servType = afOrder.getServType();
            if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(servType)) {
                uocShipOrderItem.setReturnCount(returnCount);
            }
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            this.shipOrderRepository.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(orderId);
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setAfterServingCount(returnCount.negate());
            if (UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(servType)) {
                uocSaleOrderItem.setReturnCount(returnCount);
            }
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            this.saleOrderRepository.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
        }
    }
}

