/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.UocDealMsgService;
import com.tydic.dyc.oc.service.domainservice.bo.UocDealMsgReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocDealMsgRspBo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="OC_GROUP_DEV", serviceInterface=UocDealMsgService.class)
public class UocDealMsgServiceImpl
implements UocDealMsgService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private Environment environment;

    public UocDealMsgRspBo dealMsg(UocDealMsgReqBo reqBo) {
        UocDealMsgRspBo rspBo = new UocDealMsgRspBo();
        UocDMsgPoolQryBo uocDMsgPoolQryBo = new UocDMsgPoolQryBo();
        uocDMsgPoolQryBo.setMsgId(reqBo.getMsgId());
        uocDMsgPoolQryBo = this.iUocOrderModel.getModelByMsgId(uocDMsgPoolQryBo);
        this.generalShipTable(uocDMsgPoolQryBo);
        return rspBo;
    }

    public void generalShipTable(UocDMsgPoolQryBo uocDMsgPoolQryBo) {
        List<UocOrderQueryIndex> uocOrderQueryIndexList;
        this.validataArg(uocDMsgPoolQryBo);
        if ((this.environment.getProperty("SUPPLIER_JD_ID").equals(String.valueOf(uocDMsgPoolQryBo.getSupNo())) || this.environment.getProperty("SUPPLIER_SUNING_ID").equals(String.valueOf(uocDMsgPoolQryBo.getSupNo()))) && StringUtils.isBlank((CharSequence)uocDMsgPoolQryBo.getPackageId())) {
            uocDMsgPoolQryBo.setPackageId(uocDMsgPoolQryBo.getOutOrderId());
        }
        if ((uocOrderQueryIndexList = this.getOrderQueryIndex(uocDMsgPoolQryBo)) == null) {
            throw new BaseBusinessException("101003", "\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u5916\u90e8\u8ba2\u5355[" + uocDMsgPoolQryBo.getOutOrderId() + "]\u6240\u5bf9\u5e94\u7684\u5185\u90e8\u8ba2\u5355\u4fe1\u606f!");
        }
        UocSaleOrderDo uocSaleOrderDo = this.qrySale(uocDMsgPoolQryBo.getOrderId());
        String currentSaleOrderState = uocSaleOrderDo.getSaleOrderState();
    }

    public void validataArg(UocDMsgPoolQryBo uocDMsgPoolQryBo) {
        if (StringUtils.isEmpty((CharSequence)uocDMsgPoolQryBo.getOutOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)uocDMsgPoolQryBo.getPackageId())) {
            throw new BaseBusinessException("100001", "\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u5916\u90e8\u53d1\u8d27\u5355\u7f16\u53f7[packageId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocDMsgPoolQryBo.getSupNo())) {
            throw new BaseBusinessException("100001", "\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u4f9b\u5e94\u5546\u7f16\u53f7[supNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public List<UocOrderQueryIndex> getOrderQueryIndex(UocDMsgPoolQryBo uocDMsgPoolQryBo) {
        ArrayList rspBO = new ArrayList();
        UocOrderQueryIndexQryBo qryBo = new UocOrderQueryIndexQryBo();
        qryBo.setOrderSystem("2");
        qryBo.setOutObjId(uocDMsgPoolQryBo.getOutOrderId());
        List<UocOrderQueryIndex> uocOrderQueryIndexList = this.iUocOrderModel.qryOrderQueryIndexList(qryBo);
        return uocOrderQueryIndexList;
    }

    public UocSaleOrderDo qrySale(Long orderId) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(orderId);
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        return uocSaleOrderDo;
    }
}

