/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocEvaluateQryBo;
import com.tydic.dyc.oc.model.order.sub.UocEvaluate;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.UocEvaluateDealService;
import com.tydic.dyc.oc.service.domainservice.bo.UocEvaluateDealServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEvaluateDealServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="OC_GROUP_DEV", serviceInterface=UocEvaluateDealService.class)
public class UocEvaluateDealServiceImpl
implements UocEvaluateDealService {
    private static final Logger log = LoggerFactory.getLogger(UocEvaluateDealServiceImpl.class);
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    public UocEvaluateDealServiceRspBo dealEvaluate(UocEvaluateDealServiceReqBo reqBo) {
        this.val(reqBo);
        Long objId = null;
        Long orderId = null;
        if (StringUtils.isNotBlank((CharSequence)reqBo.getSaleOrderNo())) {
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setSaleOrderNo(reqBo.getSaleOrderNo());
            uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
            objId = uocSaleOrderDo.getSaleOrderId();
            orderId = uocSaleOrderDo.getOrderId();
        } else {
            objId = reqBo.getSaleOrderId();
            orderId = reqBo.getOrderId();
        }
        UocEvaluateQryBo uocEvaluateQryBo = new UocEvaluateQryBo();
        uocEvaluateQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocEvaluateQryBo.setObjId(objId);
        uocEvaluateQryBo.setOrderId(orderId);
        List<UocEvaluate> uocEvaluates = this.iUocOrderModel.qryOrderEvaluateList(uocEvaluateQryBo);
        if (CollectionUtils.isNotEmpty(uocEvaluates)) {
            for (UocEvaluate uocEvaluate : uocEvaluates) {
                UocEvaluate uocEva = new UocEvaluate();
                uocEva.setId(uocEvaluate.getId());
                uocEva.setEvaluateState(reqBo.getEvaluateState());
                this.iUocOrderModel.updateOrderEvaluate(uocEva);
            }
            UocEvaluateDealServiceRspBo success = UocRu.success(UocEvaluateDealServiceRspBo.class);
            success.setOrderId(orderId);
            success.setSaleOrderId(objId);
            return success;
        }
        UocEvaluate uocEvaluate = new UocEvaluate();
        uocEvaluate.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocEvaluate.setId(IdUtil.nextId());
        uocEvaluate.setOrderId(orderId);
        uocEvaluate.setCreateOperId(reqBo.getUserId().toString());
        uocEvaluate.setEvaluateState(reqBo.getEvaluateState());
        uocEvaluate.setObjId(objId);
        this.iUocOrderModel.insertOrderEvaluate(uocEvaluate);
        return UocRu.success(UocEvaluateDealServiceRspBo.class);
    }

    private void val(UocEvaluateDealServiceReqBo reqBo) {
        if (ObjectUtil.isNull((Object)reqBo)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getSaleOrderNo())) {
            if (reqBo.getOrderId() == null) {
                throw new BaseBusinessException("100001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBo.getSaleOrderId() == null) {
                throw new BaseBusinessException("100001", "\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (reqBo.getEvaluateState() == null) {
            throw new BaseBusinessException("100001", "\u8bc4\u4ef7\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

