/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.UocQryShipOrderDetailsService;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsLogisticsRelaBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsRspDetailBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsRspDetailItemBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="OC_GROUP_DEV", serviceInterface=UocQryShipOrderDetailsService.class)
public class UocQryShipOrderDetailsServiceImpl
implements UocQryShipOrderDetailsService {
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private IUocOrderModel orderModel;

    public UocQryShipOrderDetailsRspBo qryShipOrderDetails(UocQryShipOrderDetailsReqBo reqBo) {
        this.validateArg(reqBo);
        Map<String, Map<String, String>> dicMap = this.getDic();
        UocQryShipOrderDetailsRspBo uocQryShipOrderDetailsRspBo = UocRu.success(UocQryShipOrderDetailsRspBo.class);
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
        Map<Object, Object> saleOrderItemMap = new HashMap();
        this.buildLogistics(reqBo, uocQryShipOrderDetailsRspBo);
        if (null != uocShipOrderDo) {
            UocShipOrderItemQryBo qryItemListBo;
            UocShipOrderDo listShipOrderItem;
            UocQryShipOrderDetailsRspDetailBo uocQryShipOrderDetailsRspDetailBo = UocRu.js(uocShipOrderDo, UocQryShipOrderDetailsRspDetailBo.class);
            if (ObjectUtil.isNotEmpty(dicMap)) {
                uocQryShipOrderDetailsRspDetailBo.setShipOrderStateStr(dicMap.get("SHIP_ORDER_STATE").get(uocShipOrderDo.getShipOrderState()));
            }
            uocQryShipOrderDetailsRspBo.setShipOrderInfo(uocQryShipOrderDetailsRspDetailBo);
            UocSaleOrderDo uocSaleOrderDo = this.getSaleOrderDo(uocShipOrderDo);
            if (null != uocSaleOrderDo) {
                if (ObjectUtil.isNotEmpty((Object)uocSaleOrderDo.getStakeholder())) {
                    BeanUtils.copyProperties((Object)uocSaleOrderDo.getStakeholder(), (Object)uocQryShipOrderDetailsRspDetailBo);
                    uocQryShipOrderDetailsRspDetailBo.setSaleOrderNo(uocSaleOrderDo.getSaleOrderNo());
                }
                UocSaleOrderDo uocSaleOrderItem = this.getSaleOrderItemList(uocSaleOrderDo);
                saleOrderItemMap = uocSaleOrderItem.getSaleOrderItems().stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
            }
            if (ObjectUtil.isNotEmpty((Object)(listShipOrderItem = this.iUocShipOrderModel.getListShipOrderItem(qryItemListBo = UocRu.js(reqBo, UocShipOrderItemQryBo.class)))) && ObjectUtil.isNotEmpty(listShipOrderItem.getShipOrderItemBoList())) {
                List<UocShipOrderItem> shipOrderItemBoList = listShipOrderItem.getShipOrderItemBoList();
                uocQryShipOrderDetailsRspDetailBo.setShipOrderItemBoList(new ArrayList());
                for (UocShipOrderItem uocShipOrderItem : shipOrderItemBoList) {
                    UocQryShipOrderDetailsRspDetailItemBo rspItemBo = new UocQryShipOrderDetailsRspDetailItemBo();
                    if (ObjectUtil.isNotEmpty(saleOrderItemMap) && saleOrderItemMap.containsKey(uocShipOrderItem.getSaleOrderItemId())) {
                        UocSaleOrderItem uocSaleOrderItem = (UocSaleOrderItem)saleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());
                        if (uocShipOrderItem.getSendCount() != null && uocShipOrderItem.getReturnCount() != null && uocSaleOrderItem.getAfterServingCount() != null) {
                            BigDecimal afterCountEnable = uocShipOrderItem.getSendCount().subtract(uocShipOrderItem.getReturnCount()).subtract(uocSaleOrderItem.getAfterServingCount());
                            rspItemBo.setAvailableAfServCount(afterCountEnable);
                        }
                        BeanUtils.copyProperties((Object)uocSaleOrderItem, (Object)rspItemBo);
                    }
                    BeanUtils.copyProperties((Object)uocShipOrderItem, (Object)rspItemBo);
                    if (ObjectUtil.isNotEmpty(dicMap)) {
                        if (ObjectUtil.isNotEmpty((Object)uocShipOrderItem.getShipItemState())) {
                            rspItemBo.setShipItemStateStr(dicMap.get("SHIP_ORDER_STATE").get(uocShipOrderItem.getShipItemState()));
                        } else {
                            rspItemBo.setShipItemStateStr(dicMap.get("SHIP_ORDER_STATE").get(uocShipOrderDo.getShipOrderState()));
                        }
                    }
                    uocQryShipOrderDetailsRspDetailBo.getShipOrderItemBoList().add(rspItemBo);
                }
            }
        }
        return uocQryShipOrderDetailsRspBo;
    }

    private void buildLogistics(UocQryShipOrderDetailsReqBo reqBo, UocQryShipOrderDetailsRspBo rspBo) {
        Long orderId = reqBo.getOrderId();
        UocOrdLogisticsRelaQryBo uocOrdLogisticsRelaQryBo = new UocOrdLogisticsRelaQryBo();
        uocOrdLogisticsRelaQryBo.setOrderId(orderId);
        UocOrdLogisticsRela uocOrdLogisticsRela = this.orderModel.qryOrderLogisticsRela(uocOrdLogisticsRelaQryBo);
        if (ObjectUtil.isNotEmpty((Object)uocOrdLogisticsRela)) {
            rspBo.setOrdLogisticsRela(UocRu.js(uocOrdLogisticsRela, UocQryShipOrderDetailsLogisticsRelaBo.class));
        }
    }

    private void validateArg(UocQryShipOrderDetailsReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocQryShipOrderDetailsReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getShipOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d1\u8d27\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UocSaleOrderDo getSaleOrderDo(UocShipOrderDo uocShipOrderDo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocSaleOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
        return this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private UocSaleOrderDo getSaleOrderItemList(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        return this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("SHIP_ORDER_STATE");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}

